/*
 * Decompiled with CFR 0.152.
 */
package org.jbars;

import java.awt.Color;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbars.Barcode;
import org.jbars.Barcode128;
import org.jbars.Barcode93;
import org.jbars.BarcodeInter25;

public class BarcodeServlet
extends HttpServlet {
    private static final int DEFAULT_BARCODE_HEIGTH = 50;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String string = httpServletRequest.getParameter("barcodeType");
            String string2 = httpServletRequest.getParameter("barcodeValue");
            String string3 = httpServletRequest.getParameter("sizeX");
            String string4 = httpServletRequest.getParameter("sizeY");
            String string5 = httpServletRequest.getParameter("rotation");
            httpServletRequest.getParameter("barColor");
            httpServletRequest.getParameter("backColor");
            String string6 = httpServletRequest.getParameter("showText");
            String string7 = httpServletRequest.getParameter("fontName");
            String string8 = httpServletRequest.getParameter("fontSize");
            String string9 = httpServletRequest.getParameter("fontStyle");
            String string10 = httpServletRequest.getParameter("transparent");
            String string11 = httpServletRequest.getParameter("alignment");
            String string12 = httpServletRequest.getParameter("imageFormat");
            String string13 = httpServletRequest.getParameter("quietZone");
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            String string14 = null;
            if (string == null) {
                bl = true;
                string14 = "Error!\nBarcode type parameter(barcodeType) is missing.";
            } else if (string2 == null) {
                bl = true;
                string14 = "Error!\nBarcode value parameter(barcodeValue) is missing.";
            } else if (string3 == null) {
                n = 0;
            } else {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    string14 = "Error!\nBarcode size isn't expresed in a numeric format.\nDetails:" + numberFormatException;
                }
            }
            if (string4 == null) {
                n2 = 0;
            } else {
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    string14 = "Error!\nBarcode size isn't expressed in a numeric format.\nDetails:" + numberFormatException;
                }
            }
            if (string13 != null && string13.trim().equals("")) {
                try {
                    n3 = Integer.parseInt(string13);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    string14 = "Error!\nBarcode quiet zone width isn't expresed in a numeric format or as a empty string.\nDetails:" + numberFormatException;
                }
            } else {
                n3 = -1;
            }
            if (string12 == null) {
                string12 = "PNG";
            }
            if (bl) {
                try {
                    httpServletResponse.sendError(400, string14);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            if (string12.equals("PNG")) {
                httpServletResponse.setContentType("image/x-png");
            } else if (string12.equals("JPG")) {
                httpServletResponse.setContentType("image/jpeg");
            }
            Barcode barcode = null;
            if (string.equalsIgnoreCase("CODE128")) {
                barcode = new Barcode128();
                barcode.setCodeType(9);
            } else if (string.equalsIgnoreCase("CODE93")) {
                barcode = new Barcode93();
            } else if (string.equalsIgnoreCase("INTERLEAVED2OF5")) {
                barcode = new BarcodeInter25();
            }
            barcode.setCode(string2);
            if (n == 0) {
                n = Math.round(barcode.getBarcodeWidth());
            }
            if (n2 == 0) {
                n2 = 50;
            }
            if (n3 >= 0) {
                barcode.setQuietZone(true);
                barcode.setQuietZoneX(n3);
            } else if (n3 < 0) {
                barcode.setQuietZone(false);
            }
            if (string6 != null && string6.equalsIgnoreCase("false")) {
                barcode.setShowText(false);
            }
            try {
                if (string7 != null) {
                    barcode.setFontName(string7);
                }
                if (string8 != null) {
                    barcode.setFontSize(Integer.parseInt(string8));
                }
                if (string9 != null) {
                    int n4 = 0;
                    if (string9.equalsIgnoreCase("BOLD")) {
                        n4 = 1;
                    } else if (string9.equalsIgnoreCase("ITALIC")) {
                        n4 = 2;
                    }
                    barcode.setFontStyle(n4);
                }
            }
            catch (Exception exception) {
                try {
                    httpServletResponse.sendError(400, exception.toString());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (string10 != null && string10.equalsIgnoreCase("false")) {
                barcode.setTransparent(false);
            }
            if (string11 != null) {
                if (string11.equalsIgnoreCase("CENTER")) {
                    barcode.setTextAlignment(2);
                }
                if (string11.equalsIgnoreCase("LEFT")) {
                    barcode.setTextAlignment(0);
                }
                if (string11.equalsIgnoreCase("RIGHT")) {
                    barcode.setTextAlignment(1);
                }
            }
            byte[] byArray = null;
            if (string5 != null && !string5.equalsIgnoreCase("0")) {
                double d = 0.0;
                if (string5.equalsIgnoreCase("90")) {
                    d = 1.5707963267948966;
                } else if (string5.equalsIgnoreCase("180")) {
                    d = Math.PI;
                } else if (string5.equalsIgnoreCase("270")) {
                    d = 4.71238898038469;
                }
                try {
                    if (string12.equals("PNG")) {
                        byArray = barcode.createPNG(n, n2, 1, Color.black, Color.black, d);
                    }
                    if (string12.equals("JPG")) {
                        byArray = barcode.createJPG(n, n2, 1, Color.black, Color.black, d);
                    }
                    httpServletResponse.sendError(400, "Cannot process image format:" + string12 + "\tValid formats are PNG and JPG");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            } else if (string12.equals("PNG")) {
                byArray = barcode.createPNG(n, n2, 1, Color.black, Color.black);
            } else if (string12.equals("JPG")) {
                byArray = barcode.createJPG(n, n2, 1, Color.black, Color.black);
            } else {
                httpServletResponse.sendError(400, "Cannot process image format:" + string12 + "\tValid formats are PNG and JPG");
            }
            httpServletResponse.setContentLength(byArray.length);
            try {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.write(byArray);
                servletOutputStream.flush();
                servletOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    httpServletResponse.sendError(500, iOException.toString());
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

