/*
 * Decompiled with CFR 0.152.
 */
package org.jbars;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jbars.Barcode;

public class BarcodeInter25
extends Barcode {
    static byte[][] BARS;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[5];
        byArray[2] = 1;
        byArray[3] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[0] = 1;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[1] = 1;
        byArray3[4] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[2] = 1;
        byArray5[4] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[0] = 1;
        byArray6[2] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[1] = 1;
        byArray10[3] = 1;
        byArrayArray[9] = byArray10;
        BARS = byArrayArray;
    }

    public BarcodeInter25() {
        this.x = 1.0f;
        this.n = 3.0f;
        this.setFont(new Font("Helvetica", 0, 20));
        this.textAlignment = 2;
        this.generateChecksum = false;
        this.checksumText = false;
    }

    public float getBarcodeWidth() {
        String string = BarcodeInter25.keepNumbers(this.code);
        int n = string.length();
        if (this.generateChecksum) {
            ++n;
        }
        float f = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        if (this.isQuietZone()) {
            Math.round((float)this.quietZoneX * this.x);
            f += (float)(this.quietZoneX * 2) * this.x;
        }
        return f;
    }

    public static byte[] getBarsInter25(String string) {
        string = BarcodeInter25.keepNumbers(string);
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        int n2 = string.length() / 2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = string.charAt(n3 * 2) - 48;
            int n5 = string.charAt(n3 * 2 + 1) - 48;
            byte[] byArray2 = BARS[n4];
            byte[] byArray3 = BARS[n5];
            int n6 = 0;
            while (n6 < 5) {
                byArray[n++] = byArray2[n6];
                byArray[n++] = byArray3[n6];
                ++n6;
            }
            ++n3;
        }
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        return byArray;
    }

    public static char getChecksum(String string) {
        int n = 3;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            int n4 = string.charAt(n3) - 48;
            n2 += n * n4;
            n ^= 2;
            --n3;
        }
        return (char)((10 - n2 % 10) % 10 + 48);
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void placeBarcode(BufferedImage bufferedImage, Color color, Color color2) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        String string = this.code;
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        if (this.isShowText() && this.getFont() != null) {
            graphics2D.setFont(this.getFont());
            if (this.generateChecksum && this.checksumText) {
                string = String.valueOf(string) + BarcodeInter25.getChecksum(string);
            }
            object = graphics2D.getFontMetrics();
            f = ((FontMetrics)object).stringWidth(string);
            float cfr_ignored_0 = n2 - ((FontMetrics)object).getMaxDescent();
            n3 = ((FontMetrics)object).getMaxAscent() + ((FontMetrics)object).getMaxDescent() + ((FontMetrics)object).getLeading();
            n4 = ((FontMetrics)object).getMaxDescent();
        }
        this.barHeight = n2 - n3;
        object = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            object = String.valueOf(object) + BarcodeInter25.getChecksum((String)object);
        }
        int n5 = ((String)object).length();
        float f2 = (float)n5 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 1: {
                f4 = (float)n - f;
                break;
            }
            default: {
                f4 = ((float)n - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        f6 = n2 - n4;
        int n6 = 0;
        if (this.isQuietZone()) {
            n6 = this.scale(n, f2 += (float)(this.quietZoneX * 2) * this.x, (float)this.quietZoneX * this.x);
        }
        byte[] byArray = BarcodeInter25.getBarsInter25((String)object);
        boolean bl = true;
        if (color != null) {
            graphics2D.setPaint(color);
        }
        int n7 = 0;
        while (n7 < byArray.length) {
            float f7;
            float f8 = f7 = byArray[n7] == 0 ? this.x : this.x * this.n;
            if (bl) {
                graphics2D.fill(new Rectangle(n6 + this.scale(n, f2, f3), this.scale(n2, this.barHeight, f5), this.scale(n, f2, f7), Math.round(this.barHeight)));
            }
            bl = !bl;
            f3 += f7;
            ++n7;
        }
        if (this.isShowText() && this.getFont() != null) {
            graphics2D.drawString(string, f4, f6);
        }
    }
}

