/*
 * Decompiled with CFR 0.152.
 */
package org.jbars;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.jbars.Barcode;
import org.jbars.Barcode128;
import org.jbars.Barcode93;
import org.jbars.BarcodeInter25;

class BarcodeGenerator {
    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage:\njava jbars.BarcodeGenerator  OutputFileName BarcodeType code sizeY [-fontName=FontName] [-fontSize=FontSize] [-fontStyle=FontStyle] [-transparent] [-rotation=rotation] [-barColor=BarColor] [-textColor=TextColor] [-alignment=textAlignment] [-dontShowText] [-imageFormat=imageFormat] [-quietZone=quietZoneWidth]");
            System.out.println("BarcodeType: CODE128, CODE93,INTER25");
            System.out.println("code: The barcode code to print");
            System.out.println("sizeY: pixel height of the image(X size is calculated to the non-distorting optimun size)");
            System.out.println("*Optional* fontName: font to use in the text, must be a VM supported font");
            System.out.println("*Optional* fontSize: size of the font");
            System.out.println("*Optional* fontStyle: PLAIN|BOLD|ITALIC");
            System.out.println("*Optional* transparent: if present the backgroud will be transparent");
            System.out.println("*Optional* rotation: degrees to rotate de image: 0,90,180 or 270");
            System.out.println("*Optional* barColor: color to use for the bars in hexadecimal ARBG format, 0x12C4A276 for example");
            System.out.println("*Optional* textColor: color to use for the text in hexadecimal ARBG format, 0x12C4A276 for example");
            System.out.println("*Optional* alignment: text alignment: LEFT, RIGHT OR CENTER");
            System.out.println("*Optional* dontShowText: if present no text will be shown");
            System.out.println("*Optional* imageFormat: format of the image to generate: PNG OR JPG (default is PNG)");
            System.out.println("*Optional* quietZone: number of blank bars to prepend and append as blank zone(quiet zone)");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = "PNG";
        String string15 = null;
        int n = 4;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-fontName=")) {
                string5 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-fontSize=")) {
                string6 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-fontStyle=")) {
                string7 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-transparent")) {
                string8 = "true";
            }
            if (stringArray[n].startsWith("-rotation=")) {
                string9 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-barColor=")) {
                string10 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-textColor=")) {
                string11 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-alignment=")) {
                string12 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            if (stringArray[n].startsWith("-dontShowText")) {
                string13 = "true";
            }
            if (stringArray[n].startsWith("-imageFormat=") && !(string14 = stringArray[n].substring(stringArray[n].indexOf("=") + 1)).equals("PNG") && !string14.equals("JPG")) {
                System.out.println("WARNING!    Unknow image format. Image formar must be PNG or JPG\nWARNING!    Using PNG format as a fallback");
                string14 = "PNG";
            }
            if (stringArray[n].startsWith("-quietZone")) {
                string15 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
            }
            ++n;
        }
        Barcode barcode = null;
        if (string2.equalsIgnoreCase("CODE128")) {
            barcode = new Barcode128();
        }
        if (string2.equalsIgnoreCase("CODE93")) {
            barcode = new Barcode93();
        }
        if (string2.equalsIgnoreCase("INTER25")) {
            barcode = new BarcodeInter25();
        }
        if (barcode == null) {
            System.out.println("Unknow barcode type: " + string2);
            System.exit(1);
        }
        if (string12 != null) {
            if (string12.equalsIgnoreCase("CENTER")) {
                barcode.setTextAlignment(2);
            }
            if (string12.equalsIgnoreCase("LEFT")) {
                barcode.setTextAlignment(0);
            }
            if (string12.equalsIgnoreCase("RIGHT")) {
                barcode.setTextAlignment(1);
            }
        } else {
            barcode.setTextAlignment(2);
        }
        if (string13 != null) {
            barcode.setShowText(false);
        }
        if (string15 != null) {
            barcode.setQuietZone(true);
            barcode.setQuietZoneX(Integer.parseInt(string15));
        }
        barcode.setCode(string3);
        if (string8 != null) {
            barcode.setTransparent(true);
        }
        if (string5 != null) {
            barcode.setFontName(string5);
        }
        if (string6 != null) {
            barcode.setFontSize(Integer.parseInt(string6));
        }
        if (string7 != null) {
            int n2 = 0;
            if (string7.equalsIgnoreCase("BOLD")) {
                n2 = 1;
            } else if (string7.equalsIgnoreCase("ITALIC")) {
                n2 = 2;
            }
            barcode.setFontStyle(n2);
        }
        Color color = string10 != null ? new Color(Integer.decode(string10)) : Color.black;
        Color color2 = string11 != null ? new Color(Integer.decode(string11)) : Color.black;
        double d = 0.0;
        if (string9 != null) {
            if (string9.equals("90")) {
                d = 1.5707963267948966;
            }
            if (string9.equals("180")) {
                d = Math.PI;
            }
            if (string9.equals("270")) {
                d = 4.71238898038469;
            }
        }
        try {
            byte[] byArray = null;
            if (string14.equals("PNG")) {
                byArray = barcode.createPNG(Integer.parseInt(string4), color, color2, d);
            } else if (string14.equals("JPG")) {
                byArray = barcode.createJPG(Integer.parseInt(string4), color, color2, d);
            } else {
                System.out.println("Unknow image format: " + string14);
                System.exit(1);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error:" + exception);
            exception.printStackTrace();
        }
    }

    private static void printCode128() {
        try {
            BufferedImage bufferedImage = new BufferedImage(600, 275, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.green);
            graphics2D.fillRect(0, 0, 600, 275);
            Barcode128 barcode128 = new Barcode128();
            barcode128.setCodeType(9);
            barcode128.setCode("2800618795811");
            barcode128.placeBarcode(bufferedImage, Color.black, Color.blue);
            JFrame jFrame = new JFrame("codigos de barras");
            ((Component)jFrame).setSize(880, 200);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            JLabel jLabel = new JLabel(imageIcon);
            jFrame.getContentPane().add(jLabel);
            jFrame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printCode93() {
        try {
            Image image = Barcode.createImage("CODE93", "17");
            JFrame jFrame = new JFrame("codigos de barras");
            ((Component)jFrame).setSize(880, 200);
            ImageIcon imageIcon = new ImageIcon(image);
            JLabel jLabel = new JLabel(imageIcon);
            jFrame.getContentPane().add(jLabel);
            jFrame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printCode93aPNG() {
        try {
            Barcode93 barcode93 = new Barcode93();
            barcode93.setCodeType(12);
            barcode93.setCode("17");
            barcode93.setTransparent(true);
            barcode93.setFontSize(10);
            byte[] byArray = barcode93.createPNG(100, 50, 1, Color.black, Color.black, 4.71238898038469);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/barra.png"));
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printCodeInterleaved() {
        try {
            BufferedImage bufferedImage = new BufferedImage(200, 150, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            graphics2D.fillRect(0, 0, 200, 150);
            BarcodeInter25 barcodeInter25 = new BarcodeInter25();
            barcodeInter25.setGenerateChecksum(true);
            barcodeInter25.setQuietZone(false);
            barcodeInter25.setFont(null);
            barcodeInter25.setCode("41-1200076041-001");
            barcodeInter25.placeBarcode(bufferedImage, Color.black, Color.black);
            JFrame jFrame = new JFrame("codigos de barras");
            ((Component)jFrame).setSize(880, 200);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            JLabel jLabel = new JLabel(imageIcon);
            jFrame.getContentPane().add(jLabel);
            jFrame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

