/*
 * Decompiled with CFR 0.152.
 */
package org.jbars;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jbars.Barcode;

public class Barcode93
extends Barcode {
    static byte[] START_BAR = new byte[]{1, 1, 1, 1, 4, 1};
    static byte[] STOP_BAR = new byte[]{1, 1, 1, 1, 4, 1, 1};
    static byte[][] ESCAPE_BARS = new byte[][]{{1, 2, 1, 2, 1, 1}, {3, 1, 2, 1, 1, 1}, {3, 1, 1, 1, 2, 1}, {1, 2, 2, 2, 1, 1}};
    static byte[][] BARS = new byte[][]{{1, 3, 1, 1, 1, 2}, {1, 1, 1, 2, 1, 3}, {1, 1, 1, 3, 1, 2}, {1, 1, 1, 4, 1, 1}, {1, 2, 1, 1, 1, 3}, {1, 2, 1, 2, 1, 2}, {1, 2, 1, 3, 1, 1}, {1, 1, 1, 1, 1, 4}, {1, 3, 1, 2, 1, 1}, {1, 4, 1, 1, 1, 1}, {2, 1, 1, 1, 1, 3}, {2, 1, 1, 2, 1, 2}, {2, 1, 1, 3, 1, 1}, {2, 2, 1, 1, 1, 2}, {2, 2, 1, 2, 1, 1}, {2, 3, 1, 1, 1, 1}, {1, 1, 2, 1, 1, 3}, {1, 1, 2, 2, 1, 2}, {1, 1, 2, 3, 1, 1}, {1, 2, 2, 1, 1, 2}, {1, 3, 2, 1, 1, 1}, {1, 1, 1, 1, 2, 3}, {1, 1, 1, 2, 2, 2}, {1, 1, 1, 3, 2, 1}, {1, 2, 1, 1, 2, 2}, {1, 3, 1, 1, 2, 1}, {2, 1, 2, 1, 1, 2}, {2, 1, 2, 2, 1, 1}, {2, 1, 1, 1, 2, 2}, {2, 1, 1, 2, 2, 1}, {2, 2, 1, 1, 2, 1}, {2, 2, 2, 1, 1, 1}, {1, 1, 2, 1, 2, 2}, {1, 1, 2, 2, 2, 1}, {1, 2, 2, 1, 2, 1}, {1, 2, 3, 1, 1, 1}, {1, 2, 1, 1, 3, 1}, {3, 1, 1, 1, 1, 2}, {3, 1, 1, 2, 1, 1}, {3, 2, 1, 1, 1, 1}, {1, 1, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 1}, {2, 1, 1, 1, 3, 1}, {1, 2, 1, 2, 1, 1}, {3, 1, 2, 1, 1, 1}, {3, 1, 1, 1, 2, 1}, {1, 2, 2, 2, 1, 1}};
    public static String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*&#@";
    public static String ASCII_CHARS = "&U*A*B*C*D*E*F*G*H*I*J*K*L*M*N*O*P*Q*R*S*T*U*V*W*X*Y*Z&A&B&C&D&E  #A#B#C $ %#F#G#H#I#J +#L - . / 0 1 2 3 4 5 6 7 8 9#Z&F&G&H&I&J&V A B C D E F G H I J K L M N O P Q R S T U V W X Y Z&K&L&M&N&O&W@A@B@C@D@E@F@G@H@I@J@K@L@M@N@O@P@Q@R@S@T@U@V@W@X@Y@Z&P&Q&R&S&T";

    public Barcode93() {
        this.x = 1.0f;
        this.n = 3.0f;
        this.setFont(new Font("Helvetica", 0, 20));
        this.textAlignment = 2;
        this.generateChecksum = true;
        this.checksumText = false;
    }

    public float getBarcodeWidth() {
        String string = Barcode93.getCode93ASCII(this.code);
        if (this.generateChecksum) {
            string = Barcode93.getChecksum(string);
        }
        int n = string.length() + 2;
        float f = (float)(n * 9) * this.x + this.x;
        if (this.isQuietZone()) {
            Math.round((float)this.quietZoneX * this.x);
            f += (float)(this.quietZoneX * 2) * this.x;
        }
        return f;
    }

    static byte[] getBarsCode93(String string) {
        byte[] byArray = new byte[(string.length() + 2) * 6 + 1];
        System.arraycopy(START_BAR, 0, byArray, 0, 6);
        int n = 0;
        while (n < string.length()) {
            int n2 = CHARS.indexOf(string.charAt(n));
            if (n2 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(n) + "' is illegal in code 93.");
            }
            System.arraycopy(BARS[n2], 0, byArray, n * 6 + 6, 6);
            ++n;
        }
        System.arraycopy(STOP_BAR, 0, byArray, string.length() * 6 + 6, 7);
        return byArray;
    }

    static String getCode93ASCII(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '\u007f' || c < '\u0000') {
                throw new IllegalArgumentException("The character " + c + " is not supported in Code 93");
            }
            char c2 = ASCII_CHARS.charAt(c * 2);
            char c3 = ASCII_CHARS.charAt(c * 2 + 1);
            if (c2 != ' ') {
                string2 = String.valueOf(string2) + c2;
            }
            string2 = String.valueOf(string2) + c3;
            ++n;
        }
        return string2;
    }

    public static String getChecksum(String string) {
        int n;
        String string2 = string;
        char c = '\u0000';
        char c2 = '\u0000';
        int n2 = 0;
        int n3 = 0;
        int n4 = string2.length() - 1;
        while (n4 >= 0) {
            n = CHARS.indexOf(string2.charAt(n4));
            if (n < 0) {
                throw new IllegalArgumentException("The character '" + string2.charAt(n4) + "' is illegal in code 93.");
            }
            n3 += n * (n2 + 1);
            n2 = (n2 + 1) % 20;
            --n4;
        }
        c = CHARS.charAt(n3 % 47);
        string2 = String.valueOf(string2) + c;
        n2 = 0;
        n3 = 0;
        n4 = string2.length() - 1;
        while (n4 >= 0) {
            n = CHARS.indexOf(string2.charAt(n4));
            if (n < 0) {
                throw new IllegalArgumentException("The character '" + string2.charAt(n4) + "' is illegal in code 93.");
            }
            n3 += n * (n2 + 1);
            n2 = (n2 + 1) % 15;
            --n4;
        }
        c2 = CHARS.charAt(n3 % 47);
        string2 = String.valueOf(string2) + c2;
        return string2;
    }

    public void placeBarcode(BufferedImage bufferedImage, Color color, Color color2) {
        float f = 0.0f;
        float f2 = 0.0f;
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        String string = Barcode93.getCode93ASCII(this.code);
        float f3 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        if (this.isShowText() && this.getFont() != null) {
            graphics2D.setFont(this.getFont());
            if (this.checksumText) {
                this.code = Barcode93.getChecksum(this.code);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            f3 = fontMetrics.stringWidth(this.code);
            float cfr_ignored_0 = n2 - fontMetrics.getMaxDescent();
            n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
            n4 = fontMetrics.getMaxDescent();
        }
        this.barHeight = n2 - n3;
        if (this.generateChecksum) {
            string = Barcode93.getChecksum(string);
        }
        int n5 = string.length() + 2;
        float f4 = (float)(n5 * 9) * this.x + this.x;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 1: {
                f5 = (float)n - f3;
                break;
            }
            default: {
                f5 = ((float)n - f3) / 2.0f;
            }
        }
        float f6 = 0.0f;
        f6 = n2 - n4;
        int n6 = 0;
        if (this.isQuietZone()) {
            n6 = this.scale(n, f4 += (float)(this.quietZoneX * 2) * this.x, (float)this.quietZoneX * this.x);
        }
        byte[] byArray = Barcode93.getBarsCode93(string);
        boolean bl = true;
        if (color != null) {
            graphics2D.setPaint(color);
        }
        int n7 = 0;
        while (n7 < byArray.length) {
            float f7 = (float)byArray[n7] * this.x;
            if (bl) {
                graphics2D.fill(new Rectangle(n6 + this.scale(n, f4, f), this.scale(n2, this.barHeight, f2), this.scale(n, f4, f7), Math.round(this.barHeight)));
            }
            bl = !bl;
            f += f7;
            ++n7;
        }
        if (this.isShowText() && this.getFont() != null) {
            if (color2 != null) {
                graphics2D.setPaint(color2);
            }
            graphics2D.drawString(this.code, f5, f6);
        }
    }
}

