/*
 * Decompiled with CFR 0.152.
 */
package org.jbars;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jbars.Barcode128;
import org.jbars.Barcode93;
import org.jbars.BarcodeInter25;

public abstract class Barcode {
    public static final int EAN13 = 1;
    public static final int EAN8 = 2;
    public static final int UPCA = 3;
    public static final int UPCE = 4;
    public static final int SUPP2 = 5;
    public static final int SUPP5 = 6;
    public static final int POSTNET = 7;
    public static final int PLANET = 8;
    public static final int CODE128 = 9;
    public static final int CODE128_UCC = 10;
    public static final int CODABAR = 11;
    public static final int CODE93 = 12;
    public static final int CODE128_RAW = 13;
    protected float x;
    protected float n;
    protected float size;
    protected float barHeight;
    protected int textAlignment;
    protected boolean generateChecksum;
    protected boolean checksumText;
    protected boolean startStopText;
    protected boolean extended;
    protected String code = "";
    protected boolean guardBars;
    protected int codeType;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    protected boolean quietZone = false;
    protected Font font = null;
    protected int quietZoneX = 10;
    protected boolean showText = true;
    protected boolean transparent = false;
    protected Color backgroundColor = Color.white;
    public static final String PNG = "PNG";
    public static final String JPG = "JPG";
    public static final double ROTATE_90 = 1.5707963267948966;
    public static final double ROTATE_180 = Math.PI;
    public static final double ROTATE_270 = 4.71238898038469;
    public static final double ROTATE_0 = 0.0;
    public static final String TYPE_CODE128 = "CODE128";
    public static final String TYPE_CODE93 = "CODE93";
    public static final String TYPE_INTERLEAVED2OF5 = "INTERLEAVED2OF5";

    public static synchronized Image createImage(String string, String string2) {
        Barcode barcode = null;
        if (string.equalsIgnoreCase(TYPE_CODE128)) {
            barcode = new Barcode128();
        } else if (string.equalsIgnoreCase(TYPE_CODE93)) {
            barcode = new Barcode93();
        } else if (string.equalsIgnoreCase(TYPE_INTERLEAVED2OF5)) {
            barcode = new BarcodeInter25();
        } else {
            return null;
        }
        barcode.setCode(string2);
        barcode.setTransparent(false);
        BufferedImage bufferedImage = new BufferedImage((int)barcode.getBarcodeWidth(), 100, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, (int)barcode.getBarcodeWidth(), 100);
        barcode.placeBarcode(bufferedImage, Color.black, Color.black);
        return bufferedImage;
    }

    public static synchronized Image createImage(String string, String string2, float f, String string3, int n, boolean bl, int n2, int n3, Color color, Color color2, int n4) {
        Barcode barcode = null;
        if (string.equalsIgnoreCase(TYPE_CODE128)) {
            barcode = new Barcode128();
        } else if (string.equalsIgnoreCase(TYPE_CODE93)) {
            barcode = new Barcode93();
        } else if (string.equalsIgnoreCase(TYPE_INTERLEAVED2OF5)) {
            barcode = new BarcodeInter25();
        } else {
            return null;
        }
        barcode.setBarHeight(f);
        barcode.setFontName(string3);
        barcode.setFontSize(n);
        barcode.setCode(string2);
        barcode.setTransparent(bl);
        barcode.setTextAlignment(n2);
        barcode.setFontStyle(n3);
        BufferedImage bufferedImage = new BufferedImage((int)barcode.getBarcodeWidth(), (int)barcode.getBarHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, (int)barcode.getBarcodeWidth(), 100);
        barcode.placeBarcode(bufferedImage, color, color2);
        try {
            double d = 0.0;
            if (n4 == 180) {
                d = Math.PI;
            } else if (n4 == 90) {
                d = 1.5707963267948966;
            } else if (n4 == 270) {
                d = 4.71238898038469;
            }
            bufferedImage = Barcode.rotateImage(bufferedImage, d);
        }
        catch (Exception exception) {
            System.out.println("Error rotating image: " + exception.getMessage());
        }
        return bufferedImage;
    }

    public byte[] createPNG(int n, Color color, Color color2, double d) throws Exception {
        int n2 = Math.round(this.getBarcodeWidth());
        int n3 = 1;
        return this.createPNG(n2, n, n3, color, color2, d);
    }

    public byte[] createPNG(int n, Color color, Color color2) {
        int n2 = Math.round(this.getBarcodeWidth());
        int n3 = 1;
        return this.createPNG(n2, n, n3, color, color2);
    }

    public byte[] createPNG(int n, int n2, int n3, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
        this.placeBarcode(bufferedImage, color, color2);
        return this.encodePNG(bufferedImage);
    }

    public byte[] createPNG(int n, int n2, int n3, Color color, Color color2, double d) throws Exception {
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        BufferedImage bufferedImage2 = null;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
        this.placeBarcode(bufferedImage, color, color2);
        bufferedImage2 = Barcode.rotateImage(bufferedImage, d);
        return this.encodePNG(bufferedImage2);
    }

    public byte[] createPNG(int n, Color color, Color color2, int n2) {
        int n3 = Math.round(this.getBarcodeWidth());
        return this.createPNG(n3, n, n2, color, color2);
    }

    public byte[] createPNG(int n, Color color, Color color2, int n2, double d) throws Exception {
        int n3 = Math.round(this.getBarcodeWidth());
        return this.createPNG(n3, n, n2, color, color2, d);
    }

    protected byte[] encodePNG(BufferedImage bufferedImage) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PNGEncodeParam.RGB rGB = new PNGEncodeParam.RGB();
        if (this.isTransparent()) {
            object = new int[]{this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue()};
            rGB.setBackgroundRGB((int[])object);
            rGB.setTransparentRGB((int[])object);
        }
        rGB.setInterlacing(true);
        object = ImageCodec.createImageEncoder((String)PNG, (OutputStream)byteArrayOutputStream, (ImageEncodeParam)rGB);
        try {
            object.encode((RenderedImage)bufferedImage);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected abstract float getBarcodeWidth();

    public float getBarHeight() {
        return this.barHeight;
    }

    public String getCode() {
        return this.code;
    }

    public int getCodeType() {
        return this.codeType;
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontName() {
        if (this.font == null) {
            return null;
        }
        return this.font.getName();
    }

    public int getFontSize() {
        if (this.font == null) {
            return -1;
        }
        return this.font.getSize();
    }

    public int getFontStyle() {
        if (this.font == null) {
            return -1;
        }
        return this.font.getStyle();
    }

    public float getN() {
        return this.n;
    }

    public int getQuietZoneX() {
        return this.quietZoneX;
    }

    public float getSize() {
        return this.size;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public float getX() {
        return this.x;
    }

    public boolean isChecksumText() {
        return this.checksumText;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isGenerateChecksum() {
        return this.generateChecksum;
    }

    public boolean isGuardBars() {
        return this.guardBars;
    }

    public boolean isQuietZone() {
        return this.quietZone;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public boolean isStartStopText() {
        return this.startStopText;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public abstract void placeBarcode(BufferedImage var1, Color var2, Color var3);

    private static BufferedImage rotateImage(BufferedImage bufferedImage, double d) throws Exception {
        if (d == 0.0) {
            return bufferedImage;
        }
        if (d != 1.5707963267948966 && d != Math.PI && d != 4.71238898038469) {
            throw new Exception("Invalid rotation angle specificated. Supported angles are: PI/2,PI or (3*PI)/2");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = null;
        if (d == 1.5707963267948966 || d == 4.71238898038469) {
            bufferedImage2 = new BufferedImage(n2, n, n3);
        } else if (d == Math.PI) {
            bufferedImage2 = new BufferedImage(n, n2, n3);
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, 0.0, 0.0);
        AffineTransform affineTransform2 = null;
        if (d == 1.5707963267948966) {
            affineTransform2 = AffineTransform.getTranslateInstance(n2, 0.0);
        } else if (d == Math.PI) {
            affineTransform2 = AffineTransform.getTranslateInstance(n, n2);
        } else if (d == 4.71238898038469) {
            affineTransform2 = AffineTransform.getTranslateInstance(0.0, n);
        }
        affineTransform2.concatenate(affineTransform);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, 1);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public int scale(int n, float f, float f2) {
        return Math.round(new Float(n).floatValue() * f2 / f);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBarHeight(float f) {
        this.barHeight = f;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public void setCodeType(int n) {
        this.codeType = n;
    }

    public void setChecksumText(boolean bl) {
        this.checksumText = bl;
    }

    public void setExtended(boolean bl) {
        this.extended = bl;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontName(String string) {
        if (this.font != null) {
            this.font = new Font(string, this.font.getStyle(), this.font.getSize());
        }
    }

    public void setFontSize(int n) {
        if (this.font != null) {
            this.font = new Font(this.font.getName(), this.font.getStyle(), n);
        }
    }

    public void setFontStyle(int n) {
        if (this.font != null) {
            this.font = new Font(this.font.getName(), n, this.font.getSize());
        }
    }

    public void setGenerateChecksum(boolean bl) {
        this.generateChecksum = bl;
    }

    public void setGuardBars(boolean bl) {
        this.guardBars = bl;
    }

    public void setN(float f) {
        this.n = f;
    }

    public void setQuietZone(boolean bl) {
        this.quietZone = bl;
    }

    public void setQuietZoneX(int n) {
        this.quietZoneX = n;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public void setStartStopText(boolean bl) {
        this.startStopText = bl;
    }

    public void setTextAlignment(int n) {
        this.textAlignment = n;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public void setX(float f) {
        this.x = f;
    }

    public byte[] createJPG(int n, Color color, Color color2, double d) throws Exception {
        int n2 = Math.round(this.getBarcodeWidth());
        int n3 = 1;
        return this.createJPG(n2, n, n3, color, color2, d);
    }

    public byte[] createJPG(int n, Color color, Color color2, int n2) {
        int n3 = Math.round(this.getBarcodeWidth());
        return this.createJPG(n3, n, n2, color, color2);
    }

    public byte[] createJPG(int n, Color color, Color color2, int n2, double d) throws Exception {
        int n3 = Math.round(this.getBarcodeWidth());
        return this.createJPG(n3, n, n2, color, color2, d);
    }

    public byte[] createJPG(int n, int n2, int n3, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
        this.placeBarcode(bufferedImage, color, color2);
        return this.encodeJPG(bufferedImage);
    }

    public byte[] createJPG(int n, int n2, int n3, Color color, Color color2, double d) throws Exception {
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        BufferedImage bufferedImage2 = null;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
        this.placeBarcode(bufferedImage, color, color2);
        bufferedImage2 = Barcode.rotateImage(bufferedImage, d);
        return this.encodeJPG(bufferedImage2);
    }

    protected byte[] encodeJPG(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
        ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"JPEG", (OutputStream)byteArrayOutputStream, (ImageEncodeParam)jPEGEncodeParam);
        try {
            imageEncoder.encode((RenderedImage)bufferedImage);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

