/*
 * Decompiled with CFR 0.152.
 */
package satzpm.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import satzpm.ComandoSAT;
import satzpm.ui.JanelaAssociarAssinatura;
import satzpm.ui.JanelaAtivar;
import satzpm.ui.JanelaAtualiza;
import satzpm.ui.JanelaBloqueio;
import satzpm.ui.JanelaCancelaVenda;
import satzpm.ui.JanelaComunicarCertificado;
import satzpm.ui.JanelaEnviarCupom;
import satzpm.ui.JanelaEstado;
import satzpm.ui.JanelaLogs;
import satzpm.ui.JanelaRede;
import satzpm.ui.JanelaSessao;
import satzpm.ui.JanelaTeste;
import satzpm.ui.JanelaTesteFimAFim;
import satzpm.ui.JanelaTrocaCodigo;

public class JanelaPrincipal
extends JFrame {
    ComandoSAT comandoSAT;
    JPanel janelaAtual;
    JFrame janelaPopup = null;

    public JanelaPrincipal(ComandoSAT novo) {
        this.janelaAtual = new JanelaEstado(novo);
        this.comandoSAT = novo;
        if (this.comandoSAT.getResultado() != 10000) {
            this.janelaAtual = new JanelaAtivar(novo);
        }
        this.createWindow();
        this.getContentPane().add(this.janelaAtual);
    }

    public void novaJanela(JPanel nova) {
        if (this.janelaAtual != null) {
            this.getContentPane().remove(this.janelaAtual);
        }
        this.janelaAtual = nova;
        if (this.janelaAtual != null) {
            this.getContentPane().add(this.janelaAtual);
        }
        this.revalidate();
        this.repaint();
    }

    private JMenuItem criaItemAtivarSAT() {
        JMenuItem item = new JMenuItem("Ativar");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.novaJanela(new JanelaAtivar(JanelaPrincipal.this.comandoSAT));
            }
        });
        return item;
    }

    private JMenuItem criaItemComunicarCertificado() {
        JMenuItem item = new JMenuItem("Comunicar certificado ICP-Brasil");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.novaJanela(new JanelaComunicarCertificado(JanelaPrincipal.this.comandoSAT));
            }
        });
        return item;
    }

    private JMenuItem criaItemAssociarAssinatura() {
        JMenuItem item = new JMenuItem("Associar assinatura");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Associar assinatura");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaAssociarAssinatura(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(false);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemRede() {
        JMenuItem item = new JMenuItem("Rede");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Configura\u00e7\u00f5es de rede");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaRede(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(false);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemEnviarCupom() {
        JMenuItem item = new JMenuItem("Enviar Cupom");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Enviar Cupom");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaEnviarCupom(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(true);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemCancelaVenda() {
        JMenuItem item = new JMenuItem("Cancelar Venda");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Cancelar Venda");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaCancelaVenda(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(true);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemTestaEnvio() {
        JMenuItem item = new JMenuItem("Teste envio");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Teste envio");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaTeste(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(true);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemBloqueio() {
        JMenuItem item = new JMenuItem("Bloquear/Desbloquear");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Bloquear/Desbloquear");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaBloqueio(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(false);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemSenha() {
        JMenuItem item = new JMenuItem("Trocar c\u00f3digo de ativa\u00e7\u00e3o");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Trocar c\u00f3digo de ativa\u00e7\u00e3o");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaTrocaCodigo(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(false);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaItemAtualiza() {
        JMenuItem item = new JMenuItem("Atualizar");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Atualizando");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaAtualiza(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(false);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenuItem criaConsultaEstado() {
        JMenuItem item = new JMenuItem("Estado operacional");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.novaJanela(new JanelaEstado(JanelaPrincipal.this.comandoSAT));
            }
        });
        return item;
    }

    private JMenuItem criaTeste() {
        JMenuItem item = new JMenuItem("Teste fim-a-fim");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.novaJanela(new JanelaTesteFimAFim(JanelaPrincipal.this.comandoSAT));
            }
        });
        return item;
    }

    private JMenuItem criaConsultaSessao() {
        JMenuItem item = new JMenuItem("Sessao anterior");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.novaJanela(new JanelaSessao(JanelaPrincipal.this.comandoSAT));
            }
        });
        return item;
    }

    private JMenuItem criaExtrairLog() {
        JMenuItem item = new JMenuItem("Extrair Logs");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaPrincipal.this.janelaPopup = new JFrame("Extrair Logs");
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                try {
                    ImageIcon img = new ImageIcon(ImageIO.read(inStream));
                    JanelaPrincipal.this.janelaPopup.setIconImage(img.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
                }
                JanelaPrincipal.this.janelaPopup.getContentPane().add(new JanelaLogs(JanelaPrincipal.this.comandoSAT));
                JanelaPrincipal.this.janelaPopup.setResizable(true);
                JanelaPrincipal.this.janelaPopup.pack();
                JanelaPrincipal.this.janelaPopup.setLocationRelativeTo(null);
                JanelaPrincipal.this.janelaPopup.setVisible(true);
            }
        });
        return item;
    }

    private JMenu criaMenuConfigurar() {
        JMenu menu = new JMenu("Configurar");
        menu.add(this.criaItemAtivarSAT());
        menu.add(this.criaItemComunicarCertificado());
        menu.add(this.criaItemAssociarAssinatura());
        menu.add(this.criaItemRede());
        menu.add(this.criaItemBloqueio());
        menu.add(this.criaItemSenha());
        menu.add(this.criaItemAtualiza());
        return menu;
    }

    private JMenu criaMenuConsultar() {
        JMenu menu = new JMenu("Consultar");
        menu.add(this.criaConsultaEstado());
        menu.add(this.criaTeste());
        menu.add(this.criaConsultaSessao());
        menu.add(this.criaExtrairLog());
        return menu;
    }

    private JMenu criaMenuTeste() {
        JMenu menu = new JMenu("Teste");
        menu.add(this.criaItemEnviarCupom());
        menu.add(this.criaItemCancelaVenda());
        menu.add(this.criaItemTestaEnvio());
        return menu;
    }

    private JMenuBar criaBarraMenu() {
        JMenuBar barraMenu = new JMenuBar();
        barraMenu.add(this.criaMenuConfigurar());
        barraMenu.add(this.criaMenuConsultar());
        return barraMenu;
    }

    private void createWindow() {
        this.setTitle("Configurador S@T - Vers\u00e3o 01.00");
        this.setDefaultCloseOperation(3);
        this.setSize(640, 440);
        this.setResizable(true);
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("icon.png");
        try {
            ImageIcon img = new ImageIcon(ImageIO.read(inStream));
            this.setIconImage(img.getImage());
        }
        catch (IOException ex) {
            Logger.getLogger(JanelaPrincipal.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setJMenuBar(this.criaBarraMenu());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }
}

