unit ThreadGeracaoRelatorios;

interface

uses
  Classes, SysUtils, Dialogs, Graphics, Windows, Forms, ComCtrls;

type
  TThreadGerarRelatorios = class(TThread)
  public
    { Public declarations }
  private
    { Private declarations }
    procedure gerarArquivos();
    procedure LogarErro(sNomeMetodo: string; iCodErro: Integer);
    procedure Logar(sMsg: String; clFontColor: TColor = clRed; bLogarData: Boolean = False); overload;
    procedure Logar(sNomeMetodo: String; sMsg: String; clFontColor: TColor = clRed; bLogarData: Boolean = False); overload;

  protected
    procedure Execute; override;
  end;

  function eBuscarPortaVelocidade_ECF_Daruma(): Integer; StdCall; External 'DarumaFramework.dll';

var
  iNumErros: Integer;
  sLocalArquivosRelatorios: String;
  HoraIni: TDateTime;
  iPosItemListView: Integer;
implementation

uses Main, ProcessDlg, LogErros, ConfigDirGeracao, StdCtrls,
  ThreadCarregarDados;

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TThreadGerarRelatorios.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TThreadGerarRelatorios }

procedure TThreadGerarRelatorios.Logar(sMsg: String; clFontColor: TColor;
  bLogarData: Boolean);
begin
  if bLogarData then
  begin
    fmLogErros.RichEdit1.SelAttributes.Color := clHotLight;
    fmLogErros.RichEdit1.Lines.Add( FormatDateTime('dd/mm/yyyy hh:mm', Now()) );
  end;

  fmLogErros.RichEdit1.SelAttributes.Color := clFontColor;
  fmLogErros.RichEdit1.Lines.Add( sMsg + #13#10 );
end;

procedure TThreadGerarRelatorios.Logar(sNomeMetodo: String; sMsg: String;
  clFontColor: TColor; bLogarData: Boolean);
begin
  if bLogarData then
  begin
    fmLogErros.RichEdit1.SelAttributes.Color := clHotLight;
    fmLogErros.RichEdit1.Lines.Add( FormatDateTime('dd/mm/yyyy hh:mm', Now()) );
  end;

  //loga o nome do mtodo
  fmLogErros.RichEdit1.SelAttributes.Color := clBlack;
  fmLogErros.RichEdit1.SelAttributes.Style := [fsBold];
  fmLogErros.RichEdit1.Lines.Append('*** ' + sNomeMetodo + ' ***');
  fmLogErros.RichEdit1.SelAttributes.Style := [];

  fmLogErros.RichEdit1.SelAttributes.Color := clFontColor;
  fmLogErros.RichEdit1.Lines.Add( sMsg + #13#10 );
end;

procedure TThreadGerarRelatorios.LogarErro(sNomeMetodo: string; iCodErro: Integer);
var
  iAviso, iErro: integer;
  sAviso, sErro, sRetorno: string;
begin
  sRetorno := StringOfChar(' ', 300);
  sAviso   := StringOfChar(' ', 300);
  sErro    := StringOfChar(' ', 300);

  rStatusUltimoCmdInt_ECF_Daruma(iErro, iAviso);

  if iCodErro <> -12 then
    eInterpretarRetorno_ECF_Daruma(iCodErro, sRetorno)
  else
    sRetorno := 'A funo executou o comando porm o ECF sinalizou Erro e/ou Aviso.';

  if iErro <> 0 then
    eInterpretarErro_ECF_Daruma(iErro, sErro)
  else
    sErro := 'nenhum erro.';

  if iAviso <> 0 then
    eInterpretarAviso_ECF_Daruma(iAviso, sAviso)
  else
    sAviso := 'nenhum aviso.';  

  Logar(sNomeMetodo,
    'Retorno do mtodo: ' + IntToStr(iCodErro) + ' - ' + Trim(sRetorno) + #13#10 +
    'Erro: '  + #09 + IntToStr(iErro)  + ' - ' + Trim(sErro)  + #13#10 +
    'Aviso: ' + #09 + IntToStr(iAviso) + ' - ' + Trim(sAviso) + #13#10,
    clBlack,
    True);

  Inc(iNumErros);
end;

//metodo para separar os relatrios em subpastas
procedure setDirectory(sRelatorio: string);
var
  sCaminho: String;
begin
  //monta os subdiretrios a partir do diretrio informado pelo usurio
  sCaminho := fmMain.edLocalArquivos.Text + fmConfigDirGeracao.sDirGeracao;

  if (Pos('<Tipo>', sCaminho) > 0) then  //se tiver a string <Tipo> substitui pelo nome do relatrio.
    sCaminho := StringReplace(sCaminho, '<Tipo>', sRelatorio, [rfReplaceAll]);

  if (Pos('<Hora>', sCaminho) > 0) then  //se tiver a string <Tipo> substitui pelo nome do relatrio.
    sCaminho := StringReplace(sCaminho, '<Hora>', FormatDateTime('hhmm', HoraIni), [rfReplaceAll]);

  if not DirectoryExists(sCaminho) then
    ForceDirectories(sCaminho); //cria o diretrio para salvar os arquivos

  //altera o XML pois a DarumaFramework salva os relatrios no caminho especificado na chave <LocalArquivosRelatorios>
  regAlterarValor_Daruma('START\LocalArquivosRelatorios', sCaminho);
  sLocalArquivosRelatorios := sCaminho;
end;

procedure TThreadGerarRelatorios.gerarArquivos();
var
  iRetorno: Integer;
  sParamAssinatura: string;
  lvItem: TListItem;
  bErroCriticoMF, bErroCriticoMFD: Boolean;

  procedure NextItem(iRet: Integer);
  begin  
    if iPosItemListView <= fmProcessDlg.ListView1.Items.Count - 1 then
    begin
      if iRet = RET_OK then
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 2 //icone de OK
      else
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4; //icone de Warning

      Inc(iPosItemListView);
    end;
    
    if fmMain.bAbortProcess or bErroCriticoMF or bErroCriticoMFD then
      fmProcessDlg.TimerAnimacao.Enabled := False
  end;

begin

  iNumErros        := 0;
  iPosItemListView := 0;
  bErroCriticoMF   := False;
  bErroCriticoMFD  := False;

  fmProcessDlg.TimerAnimacao.Enabled := True;

  //limpa a lista de log de erros
  fmLogErros.RichEdit1.Lines.Clear;

  sLocalArquivosRelatorios := fmMain.edLocalArquivos.Text;

  with fmMain do
  begin

    {***------------------------------***
             RELATRIOS IMPRESSOS
     ***------------------------------***}

    //Imprime Leitura-X
    if chkLX.Checked and not bAbortProcess then
    begin

      iRetorno := iLeituraX_ECF_Daruma();

      if iRetorno <> RET_OK then LogarErro('Leitura-X', iRetorno);

      NextItem(iRetorno);
    end;

    //Imprime Leitura da Memoria Fiscal COMPLETA
    if chkLMF_C.Checked and not bAbortProcess then
    begin

      if bDATA then
        iRetorno := eMemoriaFiscal_ECF_Daruma(FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                  FormatDateTime('ddmmyyyy', dtpDataFinal.Date), true, 'IMP')
      else
        iRetorno := eMemoriaFiscal_ECF_Daruma(Format('%.4d', [StrToInt(edInicio.Text)]),
                  Format('%.4d', [StrToInt(edFim.Text)]), true, 'IMP');

      if iRetorno <> RET_OK then LogarErro('Leitura da Memria Fiscal Completa', iRetorno);

      NextItem(iRetorno);

    end;

    //Imprime Leitura da Memoria Fiscal SIMPLIFICADA
    if chkLMF_S.Checked and not bAbortProcess then
    begin

      if bDATA then
        iRetorno := eMemoriaFiscal_ECF_Daruma(FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                  FormatDateTime('ddmmyyyy', dtpDataFinal.Date), false, 'IMP')
      else
        iRetorno := eMemoriaFiscal_ECF_Daruma(Format('%.4d', [StrToInt(edInicio.Text)]),
                  Format('%.4d', [StrToInt(edFim.Text)]), false, 'IMP');

      if iRetorno <> RET_OK then LogarErro('Leitura da Memria Fiscal Simplificada', iRetorno);

      NextItem(iRetorno);

    end;


    {***------------------------------***
        RELATRIOS GERADOS EM ARQUIVOS
     ***------------------------------***}


    //verifica se vai assinar os relatorios e adiciona um parametro a mais
    if sChaveAssinatura <> EmptyStr then
      sParamAssinatura := '+[EAD]' + sChaveAssinatura
    else
      sParamAssinatura := EmptyStr;


   //pega a hora que iniciou a gerao dos arquivos
    HoraIni := Time();


    //VERIFICA SE  NECESSARIO GERAR O ARQUIVO DE INFORMAES DO ECF (DARUMA.INF)
    if bGerarArqInf then
    begin

      iRetorno := rGerarArquivoInformacao_ECF_Daruma();

      //Este processo  crtico ao dar erro pois sem o arquivo .inf no se pode gerar os relatrios
      if iRetorno <> RET_OK then
      begin
        LogarErro('Falha ao gerar o arquivo de informaes do ECF', iRetorno);
        fmLogErros.RichEdit1.Lines.Add('Sem o arquivo de informaes do ECF no  possvel executar os demais processos.' + #13);
        bErroCriticoMF  := True;
        bErroCriticoMFD := True;
      end;

      NextItem(iRetorno);

    end;

    //FAZ O DOWNLOAD DOS BINRIOS DA MF
    if bDownloadMF and not bAbortProcess then
    begin
      if not bErroCriticoMF then
      begin
        iRetorno := rEfetuarDownloadMF_ECF_Daruma('Daruma.mf');

        //Este processo  crtico ao dar erro pois sem o arquivo .mf no se pode gerar os relatrios
        if iRetorno <> RET_OK then 
        begin
          LogarErro('Download dos binrios da MF', iRetorno);
          if iRetorno <> -12 then  // -12 evita para o processo quando o ECF est com o papel acabando.
          begin
            bErroCriticoMF := True;
            fmLogErros.RichEdit1.Lines.Add('Sem o binrio da Memria Fiscal no  possvel executar os demais processos que dependam deste arquivo.' + #13#10);
          end;
        end;
        NextItem(iRetorno);
      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Download dos binrios da MF', 'No  possvel fazer o download dos binrios da MF sem o arquivo de informaes do ECF.');
      end;
    end;


    //FAZ O DOWNLOAD DOS BINRIOS DA MFD
    if bDownloadMFD and not bAbortProcess then
    begin
      if  not bErroCriticoMFD then
      begin
        if bDATA then
          iRetorno := rEfetuarDownloadMFD_ECF_Daruma('DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
          FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mfd')
        else if bCOO then
          iRetorno := rEfetuarDownloadMFD_ECF_Daruma('COO', edInicio.Text, edFim.Text, 'Daruma.mfd')
        else
          iRetorno := rEfetuarDownloadMFD_ECF_Daruma('CRZ', edInicio.Text, edFim.Text, 'Daruma.mfd') ;

        //Este processo  crtico ao dar erro pois sem o arquivo .mfd no se pode gerar os relatrios.
        if (iRetorno <> RET_OK) and (iRetorno <> -12) then 
        begin
          LogarErro('Download dos binrios da MFD', iRetorno);
          if iRetorno <> -12 then //-12 evita parar o processo quando o ECF est com o papel acabando.
          begin
            fmLogErros.RichEdit1.Lines.Add('Sem o binrio da Memria Fita Detalhe no  possvel executar os demais processos que dependam deste arquivo.' + #13#10);
            bErroCriticoMFD := True;
          end;
        end; 
        NextItem(iRetorno);
      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Download dos binrios da MFD', 'No  possvel fazer o download dos binrios da MFD sem o arquivo de informaes do ECF.');
      end;
    end;
         
    //ESPELHO DA MEMRIA FITA DETALHE
    if chkEMFD.Checked and not bAbortProcess then
    begin

      if fmMain.chkSepararRelatorios.Checked then
        setDirectory('Espelho da Memoria Fita Detalhe');

      if bDATA then
      begin

        iRetorno := rGerarEspelhoMFD_ECF_Daruma('1', FormatDateTime('ddmmyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyy', dtpDataFinal.Date));
      end
      else
        iRetorno := rGerarEspelhoMFD_ECF_Daruma('2', edInicio.Text, edFim.Text);

      MoveFile( PChar(fmMain.edLocalArquivos.Text + 'Espelho_MFD.txt'),
          PChar(sLocalArquivosRelatorios + 'Espelho_MFD.txt') );

      if iRetorno <> RET_OK then
        LogarErro('Espelho da Memria Fita Detalhe', iRetorno);

      NextItem(iRetorno);

    end;

    //ESPELHO DA MEMRIA FISCAL SIMPLIFICADA
    if chkEMF_S.Checked and not bAbortProcess then
    begin

      if fmMain.chkSepararRelatorios.Checked then
        setDirectory('Espelho da Memoria Fiscal Simplificada');

      if bDATA then
        iRetorno := eMemoriaFiscal_ECF_Daruma(FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyyyy', dtpDataFinal.Date), false, 'ARQ')
      else
        iRetorno := eMemoriaFiscal_ECF_Daruma(edInicio.Text, edFim.Text, false, 'ARQ');

      if FileExists(sLocalArquivosRelatorios + 'Espelho_MF_Simplificada.txt') then
        DeleteFile(PChar(sLocalArquivosRelatorios + 'Espelho_MF_Simplificada.txt'));

      MoveFile( PChar(fmMain.edLocalArquivos.Text + 'retorno.txt'),
          PChar(sLocalArquivosRelatorios + 'Espelho_MF_Simplificada.txt') );

      if iRetorno <> RET_OK then
        LogarErro('Espelho da Memria Fiscal Simplificada', iRetorno);

      NextItem(iRetorno);

    end;

    //ESPELHO DA MEMRIA FISCAL COMPLETA
    if chkEMF_C.Checked and not bAbortProcess then
    begin

      if fmMain.chkSepararRelatorios.Checked then
        setDirectory('Espelho da Memoria Fiscal Completa');

      if bDATA then
        iRetorno := eMemoriaFiscal_ECF_Daruma(FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyyyy', dtpDataFinal.Date), true, 'ARQ')
      else
        iRetorno := eMemoriaFiscal_ECF_Daruma(edInicio.Text, edFim.Text, true, 'ARQ');

      if FileExists(sLocalArquivosRelatorios + 'Espelho_MF_Completa.txt') then
        DeleteFile(PChar(sLocalArquivosRelatorios + 'Espelho_MF_Completa.txt'));

      MoveFile( PChar(fmMain.edLocalArquivos.Text + 'retorno.txt'),
        PChar(sLocalArquivosRelatorios + 'retorno.txt') );

      RenameFile(sLocalArquivosRelatorios + 'retorno.txt',
       sLocalArquivosRelatorios + 'Espelho_MF_Completa.txt');

      if iRetorno <> RET_OK then
        LogarErro('Espelho da Memria Fiscal Completa', iRetorno);

      NextItem(iRetorno);

    end;

    //MEMRIA FISCAL (NO LAYOUT DO ATO COTEPE)
    if chkMF.Checked and not bAbortProcess then
    begin
      if  not bErroCriticoMF then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('Memoria Fiscal');

        if bDATA then
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('MF' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
          FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf')
        else
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('MF' + sParamAssinatura, 'CRZ', edInicio.Text, edFim.Text, 'Daruma.mf','Daruma.mfd','Daruma.inf');

        if iRetorno <> RET_OK then LogarErro('Memria Fiscal', iRetorno);

        NextItem(iRetorno);
      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Memoria Fiscal', 'No foi possvel gerar a Memria Fiscal pois depende do binrio da MF que no foi gerado.');
      end;
    end;

    //MEMRIA FITA DETALHE
    if chkMFD.Checked and not bAbortProcess then
    begin
      if not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('Memoria Fita Detalhe');

        if bDATA then
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('MFD' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
          FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf')
        else
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('MFD' + sParamAssinatura, 'COO', edInicio.Text, edFim.Text, 'Daruma.mf','Daruma.mfd','Daruma.inf');

        if iRetorno <> RET_OK then LogarErro('Memria Fita Detalhe', iRetorno);

        NextItem(iRetorno);

      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Memoria Fita Detalhe','No foi possvel gerar a Memria Fita Detalhe pois depende do binrio da MFD que no foi gerado.');
      end;
    end;

    //***tratamento de gerao dos arquivos NF* e NF*_TDM***
    //Ambos so gerados com o mesmo nome, portanto, se gerados no mesmo diretrio um sobrescrever o outro.
    //O mtodo rGerarRelatorioOffline_ECF_Daruma se encarrega de renomear os arquivos quando  passado pro mesmo gerar
    //NF* e NF*_TDM simultaneamente. O metodo ir adicionar TDM no final do nome dos arquivos do NF*_TDM.
    //OBS: o nico modo de separar totalmente os arquivos um do outro  marcando a opo 'Separar relatrios em subpastas'
    //e marcar o modo de separao por tipo, onde cada um  gerado na pasta de acordo com o nome do relatrio,
    //logo se no estiver pra separar por tipo, os arquivos sero gerados no mesmo dir.
    if bTratamentoNFP_NFPTDM and not bAbortProcess then
    begin
      if not bErroCriticoMF or not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('');
          
        //passo pro mtodo gerar NF* e NF*_TDM, assim o mesmo se encarrega de separar os arquivos
        iRetorno := rGerarRelatorioOffline_ECF_Daruma('NFP+NFPTDM' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');

        if iRetorno <> RET_OK then LogarErro('Nota Fiscal Estadual TDM', iRetorno);

        NextItem(iRetorno);
      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Nota Fiscal Estadual TDM', 'No foi possvel gerar a Nota Fiscal Estadual TDM pois depende do binrio da MF ou MFD que no foi gerado.');
      end;

    end
    else  //caso no seja necessrio o tratamento acima, gero os arquivos separadamente
    begin

      //NOTA FISCAL/LEGAL
      if chkNFP.Checked and not bAbortProcess then
      begin
        if not bErroCriticoMFD then
        begin
          if fmMain.chkSepararRelatorios.Checked then
            setDirectory('Nota Fiscal Estadual');

          iRetorno := rGerarRelatorioOffline_ECF_Daruma('NFP' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                      FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');

          if iRetorno <> RET_OK then LogarErro('Nota Fiscal Estadual', iRetorno);

          NextItem(iRetorno);
        end
        else
        begin
          fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
          Inc(iPosItemListView);
          Logar('Nota Fiscal Estadual', 'No foi possvel gerar a Nota Fiscal Estadual pois depende do binrio da MFD que no foi gerado.');
        end;
      end;

      //NOTA FISCAL/LEGAL PAULISTA/ALAGOANA/RONDONIENSE TDM
      if chkNFP_TDM.Checked and not bAbortProcess then
      begin
        if not bErroCriticoMF and not bErroCriticoMFD then
        begin
          if fmMain.chkSepararRelatorios.Checked then
            setDirectory('Nota Fiscal Estadual TDM');

          iRetorno := rGerarRelatorioOffline_ECF_Daruma('NFPTDM' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                      FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');

          if iRetorno <> RET_OK then LogarErro('Nota Fiscal Estadual TDM', iRetorno);

          NextItem(iRetorno);
        end
        else
        begin
          fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
          Inc(iPosItemListView);
          Logar('Nota Fiscal Estadual TDM', 'No foi possvel gerar a Nota Fiscal Estadual TDM pois depende do binrio da MFD que no foi gerado.');
        end;
      end;

    end; //end do tratamento NFP/NFPTDM

    //SINTEGRA
    if chkSintegra.Checked and not bAbortProcess then
    begin
      if  not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('Sintegra');

        iRetorno := rGerarRelatorioOffline_ECF_Daruma('SINTEGRA', 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');

        if iRetorno <> RET_OK then LogarErro('Sintegra', iRetorno);

        NextItem(iRetorno);
      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Sintegra', 'No foi possvel gerar o Sintegra pois depende do binrio da MFD que no foi gerado.');
      end;
    end;

    //SPED
    if chkSPED.Checked and not bAbortProcess then
    begin
      if  not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('SPED');

          if((Trim(EDT_PIS.Text)<> '') and (Trim(EDT_COFINS.Text)<> ''))then
          begin
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('SPED[' + Trim(EDT_PIS.Text) + ';' + Trim(EDT_COFINS.Text) + ']' , 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');
          end
          else
          begin
            iRetorno := rGerarRelatorioOffline_ECF_Daruma('SPED', 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
                    FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');
          end;
        if iRetorno <> RET_OK then LogarErro('SPED', iRetorno);

        NextItem(iRetorno);

      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('SPED', 'No foi possvel gerar o SPED pois depende do binrio da MFD que no foi gerado.');
      end;
    end;

    //TDM
    if chkTDM.Checked and not bAbortProcess then
    begin
      if  not bErroCriticoMF or not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('TDM');

        if bDATA then
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('TDM' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
          FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf')
        else
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('TDM' + sParamAssinatura, 'COO', edInicio.Text, edFim.Text, 'Daruma.mf','Daruma.mfd','Daruma.inf');

        if iRetorno <> RET_OK then LogarErro('TDM', iRetorno);

        NextItem(iRetorno);

      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('TDM', 'No foi possvel gerar o TDM pois depende do binrio da MF ou MFD que no foi gerado.');
      end;
    end;

    if chkVivanota.Checked and not bAbortProcess then
    begin
      if  not bErroCriticoMF or not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
          setDirectory('Vivanota');

        if bDATA then
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('VIVANOTA' + sParamAssinatura, 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
          FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf')
        else
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('VIVANOTA' + sParamAssinatura, 'COO', edInicio.Text, edFim.Text, 'Daruma.mf','Daruma.mfd','Daruma.inf');

        if iRetorno <> RET_OK then LogarErro('VIVANOTA', iRetorno);

        NextItem(iRetorno);

      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Vivanota', 'No foi possvel gerar o Vivanota pois depende do binrio da MF ou MFD que no foi gerado.');
      end;
    end;

    // MOVIMENTO POR ECF
    if chkMovimentoPorECF.Checked and not bAbortProcess then
    begin
      if  not bErroCriticoMF or not bErroCriticoMFD then
      begin
        if fmMain.chkSepararRelatorios.Checked then
        begin
          setDirectory('MovimentoPorECF');
        end;
        if bDATA then
        begin
          iRetorno := rGerarRelatorioOffline_ECF_Daruma('MOVIMENTOPORECF', 'DATAM', FormatDateTime('ddmmyyyy', dtpDataInicial.Date),
          FormatDateTime('ddmmyyyy', dtpDataFinal.Date), 'Daruma.mf','Daruma.mfd','Daruma.inf');
        end;
        NextItem(iRetorno);

      end
      else
      begin
        fmProcessDlg.ListView1.Items[iPosItemListView].ImageIndex := 4;
        Inc(iPosItemListView);
        Logar('Movimento Por ECF', 'No foi possvel gerar o Movimento Por ECF pois depende do binrio da MF ou MFD que no foi gerado.');
      end;
    end;

    fmProcessDlg.TimerAnimacao.Enabled := False;

    //restaura o XML para o caminho original
    if fmMain.chkSepararRelatorios.Checked then
      regAlterarValor_Daruma('START\LocalArquivos', fmMain.edLocalArquivos.Text);

    fmProcessDlg.bFinalizado := True;

    if bAbortProcess then
    begin
      bAbortProcess := false;

      fmProcessDlg.lbAviso1.Visible := False;
      fmProcessDlg.lbAviso2.Visible := False;

      fmProcessDlg.ListView1.Items[fmProcessDlg.ListView1.Items.Count - 1].SubItems.Text := 'Operao abortada!';
      fmProcessDlg.ListView1.Items[fmProcessDlg.ListView1.Items.Count - 1].ImageIndex := 2;
      fmProcessDlg.btAbortar.Enabled := True;
    end
    else
    begin
      if iNumErros > 0 then
        fmProcessDlg.lbShowLog.Visible := True;

      lvItem := fmProcessDlg.ListView1.Items.Add;

      if iNumErros > 0 then
      begin
        lvItem.SubItems.Text := 'Operao concluda com erros/avisos!';
        lvItem.ImageIndex := 4;
      end
      else
      begin
        lvItem.SubItems.Text := 'Operao concluda!';
        lvItem.ImageIndex := 2;
      end;
    end;
    fmProcessDlg.btAbortar.Caption := '&Ok';
  end;
end;

procedure TThreadGerarRelatorios.Execute;
begin
  gerarArquivos();
  fmMain.ThreadCarregarDados.Resume;
  fmMain.btAtualizarDadosECF.Click;
end;

end.

