unit ThreadCarregarDadosECF;

interface

uses
  Classes, Graphics, Forms, dialogs;

type
  TThreadCarregarDadosECF = class(TThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

implementation

uses SysUtils, Main, ConfigDirGeracao;

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure ThreadCarregarDadosECF.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ ThreadCarregarDadosECF }

procedure CarregarDadosECF();
var
  sRetornoECF: String;
  sHora, sData: String;
  iRetorno: Integer;
begin
  {*** STARTUP da DarumaFramework.dll ***}

  with fmMain do
  begin
    btAtualizarDadosECF.Enabled := False;

    bECF_Online := false;
    iRetorno := rVerificarImpressoraLigada_ECF_Daruma();

    sNumSerie := '<Numero de Serie>';
    sModeloECF := '<Modelo>';

    if iRetorno = RET_ECF_DESLIGADO then
    begin
      //se no comunicou, tenta equalizar o PC com o ECF
      iRetorno := eBuscarPortaVelocidade_ECF_Daruma();
      if iRetorno <> RET_OK then
      begin
        shpStatusECF.Brush.Color := clRed;
        lbStatusECF.Caption := 'ECF Offline';

        Exit;
      end;
    end
    else
    begin
      shpStatusECF.Brush.Color := clLime;
      lbStatusECF.Caption := 'ECF online';
      bECF_Online := True;
    end;

    //obtem a data e hora do EFC
    sData := StringOfChar(' ', 14);
    sHora := StringOfChar(' ', 14);

    rDataHoraImpressora_ECF_Daruma(sData, sHora);

    lbDataHora_ECF.Caption := Format('Data/Hora atual do ECF: %s/%s/%s [%s:%s:%s]',
      [Copy(sData, 0, 2), Copy(sData, 3, 2), Copy(sData, 5, 4),
      Copy(sHora, 0, 2), Copy(sHora, 3, 2), Copy(sHora, 5, 2)]);

    //obtem a data do ultimo movimento
    sRetornoECF := StringOfChar(' ', 1164);

    rRetornarInformacao_ECF_Daruma('140', sRetornoECF);
    lbDataUltMovto_ECF.Caption := Format('Data do ultimo movimento: %s/%s/%s',
    [Copy(sRetornoECF, 0, 2), Copy(sRetornoECF, 3, 2), Copy(sRetornoECF, 5, 4)]);

    //defini a data mxima dos DateTimePickers baseada na data da ultima Raduo-Z .. justamente pq no tem movimento aps essa data :)
    //dtpDataInicial.MaxDate := StrToDate(Format('%s/%s/%s',
    //[Copy(sRetornoECF, 0, 2), Copy(sRetornoECF, 3, 2), Copy(sRetornoECF, 5, 4)]));
    //dtpDataFinal.MaxDate := dtpDataInicial.MaxDate;

    //verifica se tem Reduo-Z pendente
    sRetornoECF := StringOfChar(' ', 1);

    rVerificarReducaoZ_ECF_Daruma(sRetornoECF);
    if sRetornoECF = '0' then
      lbRZPendente.Caption := 'Reduo-Z pendente: NO'
    else
      lbRZPendente.Caption := 'Reduo-Z pendente: SIM';

    //obtem o nmero do COO
    sRetornoECF := StringOfChar(' ', 6);
    rRetornarInformacao_ECF_Daruma('26', sRetornoECF);
    lbCOO.Caption := 'COO: ' + sRetornoECF;

    //obtem o nmero do CCF
    sRetornoECF := StringOfChar(' ', 6);
    rRetornarInformacao_ECF_Daruma('30', sRetornoECF);
    lbCCF.Caption := 'CCF: ' + sRetornoECF;

    //obtem o nmero do CRZ
    sRetornoECF := StringOfChar(' ', 4);
    rRetornarInformacao_ECF_Daruma('24', sRetornoECF);
    lbCRZ.Caption := 'CRZ: ' + sRetornoECF;

    //obtem o Nmero de Srie do ECF
    sRetornoECF := StringOfChar(' ', 21);
    rRetornarInformacao_ECF_Daruma('78', sRetornoECF);
    sNumSerie := sRetornoECF;
    lbNumSerie.Caption := 'Nmero de Srie: ' + sNumSerie;

    //obtem os valores mximos de COO e CRZ
    sRetornoECF := StringOfChar(' ', 6);
    rRetornarInformacao_ECF_Daruma('26', sRetornoECF);
    iNumCOO := StrToInt(sRetornoECF);

    sRetornoECF := StringOfChar(' ', 4);
    rRetornarInformacao_ECF_Daruma('24', sRetornoECF);
    iNumCOO := StrToInt(sRetornoECF);

    //obtem o modelo do ECF
    sRetornoECF := StringOfChar(' ', 20);
    rRetornarInformacao_ECF_Daruma('81', sRetornoECF);
    sModeloECF := Trim(sRetornoECF);
    lbModeloECF.Caption := 'Modelo do ECF: ' + sModeloECF;

    //obtem a porta COM e a velocidade no XML
    sRetornoECF := StringOfChar(' ', 10);
    regRetornaValorChave_DarumaFramework('ECF', 'PortaSerial', sRetornoECF);
    lbPortaCOM.Caption := 'Porta: ' + Trim(sRetornoECF);
    sRetornoECF := StringOfChar(' ', 15);
    regRetornaValorChave_DarumaFramework('ECF', 'Velocidade', sRetornoECF);
    lbPortaCOM.Caption := lbPortaCOM.Caption + ' [' + Trim(sRetornoECF) + ']';

    //configura o caminho default da separao dos relatrios
    fmConfigDirGeracao.sDirGeracao := sModeloECF + '\' +
                                      sNumSerie  + '\' +
                                      '<Tipo>'   + '\' +
                                      FormatDateTime('ddmmyy', Date()) + '\' +
                                      '<Hora>'   + '\';

    btAtualizarDadosECF.Enabled := True;
  end;

end;

procedure TThreadCarregarDadosECF.Execute;
begin

  while not Application.Terminated do
  begin

    with fmMain do
    begin

      lbDataHora_PC.Caption := 'Data/Hora do computador: ' + FormatDateTime('dd/mm/yyyy', Date()) +
          ' [' + FormatDateTime('hh:mm:ss', Time()) + ']';

      if not bECF_Online then
      begin
        CarregarDadosECF();
      end
      else
      begin

        if rVerificarImpressoraLigada_ECF_Daruma = RET_ECF_DESLIGADO then
        begin
          lbNumSerie.Caption := 'Nmero de Srie:';
          lbModeloECF.Caption := 'Modelo do ECF:';
          lbPortaCOM.Caption := 'Porta COM:';
          lbCOO.Caption := 'COO:';
          lbCRZ.Caption := 'CRZ:';
          lbCCF.Caption := 'CCR:';
          lbDataHora_ECF.Caption := 'Data/Hora do ECF:';
          lbDataUltMovto_ECF.Caption := 'Data do ultimo movimento:';
          lbRZPendente.Caption := 'Reduo-Z pendente:';
          lbStatusECF.Caption := 'ECF Offline';
          shpStatusECF.Brush.Color := clRed;

          bECF_Online := false;
        end;

        btAtualizarDadosECF.Enabled := bECF_Online;
      end;
      
    end;

    sleep(1000);

  end;
end;

end.
