unit ThreadCarregarDados;

interface

uses
  Classes, Forms, Graphics, Windows, SysUtils, Controls;

type
  TThreadCarregarDados = class(TThread)
  private
    { Private declarations }
    bStatusOld: Boolean;
    procedure CarregarDadosECF();
    procedure VerificaStatus();
    procedure AtualizarForm();
  protected
    sDataHoraECF: String;
    sReducaoZ: String;
    sPortaVelocidade: String;
    dtDataUltMvto: TDate;

    procedure Execute; override;

  public
    bRecarregadDados: Boolean;
  end;


implementation

uses Main, ConfigDirGeracao, DateUtils;

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure ThreadCarregarDados.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ ThreadCarregarDados }

procedure TThreadCarregarDados.Execute; 
begin
  { Place thread code here }

  if eDefinirProduto_Daruma('ECF') = -6 then
    eBuscarPortaVelocidade_ECF_Daruma();

  while not Application.Terminated do //enquanto no for o fim da aplicao
  begin

    VerificaStatus();

    with fmMain do
    begin

      if ECF.bOnLine <> bStatusOld then // teve variao de status
      begin

        if ECF.bOnLine then
        begin
          CarregarDadosECF();
          Synchronize( AtualizarForm );
        end
        else
        begin
          lbNumSerie.Caption := 'Nmero de Srie:';
          lbModeloECF.Caption := 'Modelo do ECF:';
          lbPortaCOM.Caption := 'Porta COM:';
          lbCOO.Caption := 'COO:';
          lbCRZ.Caption := 'CRZ:';
          lbCCF.Caption := 'CCR:';
          lbDataHora_ECF.Caption := 'Data/Hora do ECF:';
          lbDataUltMovto_ECF.Caption := 'Data do ultimo movimento:';
          lbRZPendente.Caption := 'Reduo-Z pendente:';
          lbStatusECF.Caption := 'ECF Offline';
          shpStatusECF.Brush.Color := clRed;
        end;

        bStatusOld := ECF.bOnLine;

      end;

    end;

    if bRecarregadDados then
    begin
      CarregarDadosECF();
      Synchronize( AtualizarForm );
      bRecarregadDados := False;
    end;

    Sleep(1000);

  end;

end;

procedure TThreadCarregarDados.VerificaStatus;
var
  iRetorno: Integer;
  sStatus: String;
begin
    with fmMain do
    begin
      // verifica o status da impressora para detectar se est ligada ou desligada
      sStatus := StringOfChar(' ', 14);
      ECF.bOnLine := rStatusImpressora_ECF_Daruma(sStatus) <> RET_ECF_DESLIGADO;

      if not ECF.bOnLine then
      begin
        iRetorno := eBuscarPortaVelocidade_ECF_Daruma();
        if not iRetorno = RET_ECF_DESLIGADO then
          ECF.bOnLine := True;
      end;
    end;
end;

procedure TThreadCarregarDados.CarregarDadosECF();
var
  sRetornoECF: String;
  sHora, sData: String;
  iRetorno: Integer;
begin
  {*** STARTUP da DarumaFramework.dll ***}

  with fmMain do
  begin
    btAtualizarDadosECF.Enabled := False;

    ECF.bOnLine := False;
    iRetorno := rVerificarImpressoraLigada_ECF_Daruma();

    ECF.sNumSerie := '<Numero de Serie>';
    ECF.sModeloECF := '<Modelo>';

    if iRetorno = RET_ECF_DESLIGADO then
    begin
      //se no comunicou, tenta equalizar o PC com o ECF
      iRetorno := eBuscarPortaVelocidade_ECF_Daruma();
      if iRetorno <> RET_OK then
        Exit;
    end;

    //obtem a data e hora do EFC
    sData := StringOfChar(' ', 14);
    sHora := StringOfChar(' ', 14);

    rDataHoraImpressora_ECF_Daruma(sData, sHora);

    sDataHoraECF := Format('Data/Hora atual do ECF: %s/%s/%s [%s:%s:%s]',
      [Copy(sData, 0, 2), Copy(sData, 3, 2), Copy(sData, 5, 4),
      Copy(sHora, 0, 2), Copy(sHora, 3, 2), Copy(sHora, 5, 2)]);

     try
      Main.fmMain.dtDataECF := StrToDate(Format('%s/%s/%s',
        [Copy(sData, 0, 2), Copy(sData, 3, 2), Copy(sData, 5, 4)]));
    except
    end;


    //obtem a data do ultimo movimento
    sRetornoECF := StringOfChar(' ', 1164);
    rRetornarInformacao_ECF_Daruma('140', sRetornoECF);
    try
      dtDataUltMvto := StrToDate(Format('%s/%s/%s',
        [Copy(sRetornoECF, 0, 2), Copy(sRetornoECF, 3, 2), Copy(sRetornoECF, 5, 4)]));

      Main.fmMain.dtDataUltMvto:=  dtDataUltMvto;
    except
    end;

    //verifica se tem Reduo-Z pendente
    sRetornoECF := StringOfChar(' ', 1);
    rVerificarReducaoZ_ECF_Daruma(sRetornoECF);
    if sRetornoECF = '0' then
      sReducaoZ := 'Reduo-Z pendente: NO'
    else
      sReducaoZ := 'Reduo-Z pendente: SIM';

    //obtem o nmero do COO
    sRetornoECF := StringOfChar(' ', 6);
    rRetornarInformacao_ECF_Daruma('26', sRetornoECF);
    ECF.iCOO := StrToInt(sRetornoECF);

    //obtem o nmero do CCF
    sRetornoECF := StringOfChar(' ', 6);
    rRetornarInformacao_ECF_Daruma('30', sRetornoECF);
    ECF.iCCF := StrToInt(sRetornoECF);

    //obtem o nmero do CRZ
    sRetornoECF := StringOfChar(' ', 4);
    rRetornarInformacao_ECF_Daruma('24', sRetornoECF);
    ECF.iCRZ := StrToInt(sRetornoECF);

    //obtem o Nmero de Srie do ECF
    sRetornoECF := StringOfChar(' ', 21);
    rRetornarInformacao_ECF_Daruma('78', sRetornoECF);
    ECF.sNumSerie := Trim(sRetornoECF);
    lbNumSerie.Caption := 'Nmero de Srie: ' + ECF.sNumSerie;

    //obtem o modelo do ECF
    sRetornoECF := StringOfChar(' ', 20);
    rRetornarInformacao_ECF_Daruma('81', sRetornoECF);
    ECF.sModeloECF := Trim(sRetornoECF);

    //obtem a porta COM e a velocidade no XML
    sRetornoECF := StringOfChar(' ', 10);
    regRetornaValorChave_DarumaFramework('ECF', 'PortaSerial', sRetornoECF);
    sPortaVelocidade := 'Porta: ' + Trim(sRetornoECF);

    sRetornoECF := StringOfChar(' ', 15);
    regRetornaValorChave_DarumaFramework('ECF', 'Velocidade', sRetornoECF);
    sPortaVelocidade := sPortaVelocidade + ' [' + Trim(sRetornoECF) + ']';

    btAtualizarDadosECF.Enabled := True;
    
    ECF.bOnLine := True;

    fmConfigDirGeracao.montarDiretorio();
  end;

end;

procedure TThreadCarregarDados.AtualizarForm;
begin
  //atualiza os dados do formulario
  with fmMain do
  begin

    if ECF.bOnLine then
    begin
      lbStatusECF.Caption := 'ECF Online';
      shpStatusECF.Brush.Color := clLime;
    end
    else
    begin
      lbStatusECF.Caption := 'ECF Offline';
      shpStatusECF.Brush.Color := clRed;
    end;

    lbDataHora_ECF.Caption := sDataHoraECF;

    lbDataUltMovto_ECF.Caption := 'Data do ultimo movimento: ' +
      FormatDateTime('dd/mm/yyyy', dtDataUltMvto);

    //defini a data mxima dos DateTimePickers baseada na data da ultima Raduo-Z .. justamente porque no tem movimento aps essa data :)

     if (chkEMFD.Checked and not chkEMF_C.Checked and not chkEMF_S.Checked and not
  chkMF.Checked and not chkMFD.Checked and not chkNFP.Checked and not
  chkNFP_TDM.checked and not chkSPED.Checked and not chkSintegra.Checked and not
  chkTDM.Checked and not chkVivanota.Checked) then

  begin
      dtpDataInicial.MaxDate := dtDataECF;
      dtpDataFinal.MaxDate := dtDataECF;
  end
  else
  begin
      dtpDataInicial.MaxDate := dtDataUltMvto;
      dtpDataFinal.MaxDate := dtDataUltMvto;
  end;

  //  dtpDataInicial.MaxDate := dtDataUltMvto;
  //  dtpDataFinal.MaxDate := dtDataUltMvto;

    lbRZPendente.Caption := sReducaoZ;

    lbCOO.Caption := 'COO: ' + Format('%.6u', [ECF.iCOO]);

    lbCCF.Caption := 'CCF: ' + Format('%.6u', [ECF.iCCF]);

    lbCRZ.Caption := 'CRZ: ' + Format('%.6u', [ECF.iCRZ]);

    lbModeloECF.Caption := 'Modelo do ECF: ' + ECF.sModeloECF;

    lbPortaCOM.Caption := sPortaVelocidade;

    {//configura o caminho default da separao dos relatrios
    fmConfigDirGeracao.sDirGeracao := ECF.sModeloECF + '\' +
                                      Trim(ECF.sNumSerie)  + '\' +
                                      '<Tipo>'   + '\' +
                                      FormatDateTime('ddmmyy', Date()) + '\' +
                                      '<Hora>'   + '\'; }

    fmMain.btAtualizarDadosECF.Enabled := True;
  end;
end;

end.
 