unit ProcessDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Buttons, StdCtrls, ExtCtrls, ImgList;

type
  TfmProcessDlg = class(TForm)
    Bevel1: TBevel;
    lbShowLog: TLabel;
    lbAbrirDiretorioGeracao: TLabel;
    btAbortar: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ImageList1: TImageList;
    ListView1: TListView;
    TimerAnimacao: TTimer;
    lbAviso1: TLabel;
    lbAviso2: TLabel;
    procedure btAbortarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure lbShowLogMouseEnter(Sender: TObject);
    procedure lbShowLogMouseLeave(Sender: TObject);
    procedure lbShowLogClick(Sender: TObject);
    procedure lbAbrirDiretorioGeracaoClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TimerAnimacaoTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    bFinalizado: Boolean;
    sDirArquivos: String;
  end;

var
  fmProcessDlg: TfmProcessDlg;

implementation

uses Main, LogErros, ConfigDirGeracao, ThreadGeracaoRelatorios;

{$R *.dfm}

procedure TfmProcessDlg.btAbortarClick(Sender: TObject);
var
  lvItem: TListItem;
  i: Integer;
begin
  if not bFinalizado then
  begin
    fmMain.bAbortProcess := true;

    lbAbrirDiretorioGeracao.Visible := False;
    lbAviso1.Visible := True;
    lbAviso2.Visible := True;

    lvItem := ListView1.Items.Add;
    lvItem.ImageIndex := -1;
    lvItem.SubItems.Add('Abortando operao...');
    for i := iPosItemListView + 1 to ListView1.Items.Count - 2 do
      ListView1.Items[i].ImageIndex := 3;

    btAbortar.Enabled := false;
  end
  else
    Close;
end;

procedure TfmProcessDlg.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  bFinalizado := False;

  ModalResult := mrOk;

  btAbortar.Enabled := True;
  lbShowLog.Visible := False;
  lbAbrirDiretorioGeracao.Visible := False;
  Hide; // esse Hide  pra no aparecer no caption do boto a palavra "Abortar" enquanto o form fecha. (ocorre no Win7 apenas)
  btAbortar.Caption := '&Abortar';

  ListView1.Clear;
end;

procedure TfmProcessDlg.lbShowLogMouseEnter(Sender: TObject);
begin
   //foi usada a variavel Sender desta procedure, pois esta  reutilizada pelo
   //lbAbrirDiretorioGeracao.
  (Sender as TLabel).Font.Color := clHotLight;
end;

procedure TfmProcessDlg.lbShowLogMouseLeave(Sender: TObject);
begin
  //foi usada a variavel Sender desta procedure, pois esta  reutilizada pelo lbAbrirDiretorioGeracao
  (Sender as TLabel).Font.Color := clHighlight;
end;

procedure TfmProcessDlg.lbShowLogClick(Sender: TObject);
begin
  fmLogErros.Show;
  Close;
end;

procedure TfmProcessDlg.lbAbrirDiretorioGeracaoClick(Sender: TObject);
begin  
  //chama o diretrio que foi gerado os arquivos.
  WinExec(PAnsiChar('Explorer ' + sDirArquivos), SW_SHOWNORMAL);
end;

procedure TfmProcessDlg.FormDeactivate(Sender: TObject);
begin
  //Este trecho faz com que a janela no perca o foco enquanto no for
  //encerrada pelo boto fechar ou boto Ok/Abrotar.
  if (ModalResult <> mrOk) then Show;
end;

procedure TfmProcessDlg.FormShow(Sender: TObject);
begin
  ModalResult := mrNone;
  btAbortar.Caption := '&Abortar';
  bFinalizado := false; 
end;

procedure TfmProcessDlg.TimerAnimacaoTimer(Sender: TObject);
begin
  //Faz a "animao" das setas de azul pra amarelo e vice-versa
  if ListView1.Items[ThreadGeracaoRelatorios.iPosItemListView].ImageIndex = 0 then
    ListView1.Items[ThreadGeracaoRelatorios.iPosItemListView].ImageIndex := 1
  else
    ListView1.Items[ThreadGeracaoRelatorios.iPosItemListView].ImageIndex := 0; 
end;

end.
