unit MovimentoPorECF;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TfmMovimentoPorECF = class(TForm)
    gbxParamMovimentoPorECF: TGroupBox;
    Label1: TLabel;
    edCNPJ: TEdit;
    edIE: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    edIM: TEdit;
    edDenominacao: TEdit;
    Label4: TLabel;
    edNomePAFECF: TEdit;
    Label5: TLabel;
    edVersaoPAFECF: TEdit;
    Label6: TLabel;
    Label9: TLabel;
    edVersaoERPAFECF: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label10: TLabel;
    edMD5PAFECF: TEdit;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMovimentoPorECF: TfmMovimentoPorECF;

implementation

uses Main;

{$R *.dfm}

procedure TfmMovimentoPorECF.Button2Click(Sender: TObject);
var
  i: Integer;
begin
  // Verificao se todos os campos foram preenchidos
  for i := 0 to gbxParamMovimentoPorECF.ControlCount - 1 do
  begin
    if gbxParamMovimentoPorECF.Controls[i] is TEdit then
    begin
      if Trim((gbxParamMovimentoPorECF.Controls[i] as TEdit).Text) = EmptyStr then
      begin
        MessageDlg('Todos os campos devem estar preenchidos!', mtInformation, [mbOk], 0);
        (gbxParamMovimentoPorECF.Controls[i] as TEdit).SetFocus;
        Exit;
      end;
    end;
  end;
  // Envio de valores ao arquivo DarumaFrameWork.xml
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\CNPJ', edCNPJ.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\IE', edIE.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\IM', edIM.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\Denominacao', edDenominacao.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\NomePAFECF', edNomePAFECF.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\VersaoPAFECF', edVersaoPAFECF.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\MD5PAFECF', edMD5PAFECF.Text);
  regAlterarValor_Daruma('ECF\MOVIMENTOPORECF\SOFTWAREHOUSE\VersaoERPAFECF', edVersaoERPAFECF.Text);

  ModalResult := mrOk;
end;

procedure TfmMovimentoPorECF.Button1Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
