unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Mask, Buttons,
  FileCtrl, ThreadCarregarDados, ThreadGeracaoRelatorios, IniFiles;

//Dados do ECF
type
  T_ECF = record
    bOnLine   : Boolean;
    sNumSerie : String;
    sModeloECF: String;
    iCOO      : Integer;
    iCRZ      : Integer;
    iCCF      : Integer;
  end;

type
  TfmMain = class(TForm)
    GroupBox3: TGroupBox;
    rdoCOO: TRadioButton;
    rdoCRZ: TRadioButton;
    rdoData: TRadioButton;
    btGerar: TButton;
    GroupBox4: TGroupBox;
    Label4: TLabel;
    edLocalArquivos: TEdit;
    chkSepararRelatorios: TCheckBox;
    pnlInformacoesECF: TPanel;
    lbNumSerie: TLabel;
    lbCRZ: TLabel;
    lbCCF: TLabel;
    lbCOO: TLabel;
    lbDataHora_ECF: TLabel;
    lbDataUltMovto_ECF: TLabel;
    lbDataHora_PC: TLabel;
    lbRZPendente: TLabel;
    lbStatusECF: TLabel;
    shpStatusECF: TShape;
    edInicio: TEdit;
    edFim: TEdit;
    Label2: TLabel;
    dtpDataInicial: TDateTimePicker;
    dtpDataFinal: TDateTimePicker;
    Label3: TLabel;
    btAtualizarDadosECF: TSpeedButton;
    OpenDialog1: TOpenDialog;
    lbModeloECF: TLabel;
    lbPortaCOM: TLabel;
    Bevel1: TBevel;
    Button2: TButton;
    Timer1: TTimer;
    btInfoECF: TSpeedButton;
    lbShowLog: TLabel;
    Image1: TImage;
    gbxRelatorios: TGroupBox;
    chkEMFD: TCheckBox;
    chkEMF_C: TCheckBox;
    chkEMF_S: TCheckBox;
    chkMF: TCheckBox;
    chkMFD: TCheckBox;
    chkNFP: TCheckBox;
    chkNFP_TDM: TCheckBox;
    chkSPED: TCheckBox;
    chkSintegra: TCheckBox;
    chkTDM: TCheckBox;
    gbxImpressos: TGroupBox;
    chkLX: TCheckBox;
    chkLMF_C: TCheckBox;
    chkLMF_S: TCheckBox;
    chkAssinarArquivos: TCheckBox;
    Label1: TLabel;
    Label5: TLabel;
    chkVivanota: TCheckBox;
    EDT_PIS: TEdit;
    EDT_COFINS: TEdit;
    lbl_PIS_1: TLabel;
    lbl_PIS_2: TLabel;
    lbl_PIS_3: TLabel;
    btAtendimentoClilente: TButton;
    chkGerarOffline: TCheckBox;
    chkAuditoria: TCheckBox;
    chkVelocidadeGeracao: TCheckBox;
    chkMovimentoPorECF: TCheckBox;
    procedure btInfoECFClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btGerarClick(Sender: TObject);
    procedure edInicioExit(Sender: TObject);
    procedure chkSintegra2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure tratamentoPeriodos(Sender: TObject);
    procedure chkSepararRelatoriosClick(Sender: TObject);
    procedure btAtualizarDadosECFClick(Sender: TObject);
    procedure rdoCOOClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure lbShowLogMouseEnter(Sender: TObject);
    procedure lbShowLogMouseLeave(Sender: TObject);
    procedure lbShowLogClick(Sender: TObject);
    procedure chkSintegraClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure chkAssinarArquivosClick(Sender: TObject);
    procedure btAtendimentoClilenteClick(Sender: TObject);
    procedure chkGerarOfflineClick(Sender: TObject);
    procedure chkAuditoriaClick(Sender: TObject);
    procedure chkVelocidadeGeracaoClick(Sender: TObject);
    procedure chkMovimentoPorECFClick(Sender: TObject);
  private
    { Private declarations }

    procedure habilitarPeriodo(Sender: TObject);

  public
    { Public declarations }
    ECF: T_ECF;
    bAbortProcess: Boolean;
    bCOO, bCRZ, bDATA, bDownloadMF, bDownloadMFD, bGerarArqInf, bTratamentoNFP_NFPTDM: Boolean;
    sChaveAssinatura: String;
    ThreadCarregarDados: TThreadCarregarDados;
    dtDataECF : TDate;
    dtDataUltMvto : tDate;

  end;
  
  {*** Declarao dos metodos da DarumaFramework.dll ***}

  //*** funes gerais e de consulta
  function eBuscarPortaVelocidade_ECF_Daruma(): Integer; StdCall; External 'DarumaFramework.dll';
  function eDefinirProduto_Daruma(pszProduto:string): Integer; StdCall; External 'DarumaFramework.dll';
  function rDataHoraImpressora_ECF_Daruma(pszData:string;pszHora:string): Integer; StdCall; External 'DarumaFramework.dll';
  function rRetornarInformacao_ECF_Daruma(pszIndice:string;pszRetornar:string): Integer; StdCall; External 'DarumaFramework.dll';
  function rStatusImpressora_ECF_Daruma(pszStatus:string): Integer; StdCall; External 'DarumaFramework.dll';
  function rVerificarImpressoraLigada_ECF_Daruma(): Integer; StdCall; External 'DarumaFramework.dll';
  function rVerificarReducaoZ_ECF_Daruma(zPendente:string): Integer; StdCall; External 'DarumaFramework.dll';
  function regRetornaValorChave_DarumaFramework(pszProduto:string;pszChave:string;pszValor:string):Integer; StdCall; External 'DarumaFramework.dll';
  function regAlterarValor_Daruma(pszPathChave:string;pszValor:string):Integer; StdCall; External 'DarumaFramework.dll';
  function regSintegra_ECF_Daruma(pszChave:string;pszValor:string):Integer; StdCall; External 'DarumaFramework.dll';
  function rStatusImpressoraBinario_ECF_Daruma(pszStatus:String):Integer; StdCall; External 'DarumaFramework.dll';
  function eVerificarVersaoDLL_Daruma(pszRet: String): Integer; StdCall; External 'DarumaFramework.dll';

  //*** metodos da DarumaFramework para tratamento de retornos
  function rStatusUltimoCmdInt_ECF_Daruma(var piErro:integer;var piAviso:integer): Integer; StdCall; External 'DarumaFramework.dll';
  function eInterpretarErro_ECF_Daruma(iIndice:Integer; pszRetorno:string): Integer; StdCall; External 'DarumaFramework.dll';
  function eInterpretarAviso_ECF_Daruma(iIndice:Integer; pszRetorno:string): Integer; StdCall; External 'DarumaFramework.dll';
  function eInterpretarRetorno_ECF_Daruma(iIndice:Integer; pszRetorno:string): Integer; StdCall; External 'DarumaFramework.dll';

  //*** metodos de gerao de arquivos
  function rEfetuarDownloadMF_ECF_Daruma(pszNomeArquivo:string):Integer; StdCall; External 'DarumaFramework.dll';
  function rEfetuarDownloadMFD_ECF_Daruma(pszTipo:string; pszInicial:string; pszFinal:string; pszNomeArquivo:string): Integer; StdCall; External 'DarumaFramework.dll';
  function rGerarArquivoInformacao_ECF_Daruma(): Integer; StdCall; External 'DarumaFramework.dll';
  function eMemoriaFiscal_ECF_Daruma(pszInicial:string; pszFinal:string; pszCompleta: Boolean; pszTipo:string):Integer; StdCall; External 'DarumaFramework.dll';
  function iLeituraX_ECF_Daruma(): Integer; StdCall; External 'DarumaFramework.dll';
  function rGerarEspelhoMFD_ECF_Daruma(pszTipo:string; pszInicial:string;pszFinal:string): Integer; StdCall; External 'DarumaFramework.dll';
  function rGerarRelatorioOffline_ECF_Daruma(szRelatorio:string; szTipo:string; szInicial:string; szFinal:string; szArquivo_MF:string; szArquivo_MFD:string; szArquivo_INF:string): Integer; StdCall; External 'DarumaFramework.dll';

var
  fmMain: TfmMain;

const
  RET_OK = 1;
  RET_ECF_DESLIGADO = -6;

  PROGRAM_VERSION: String = '1.7.17';
  //NO ESQUECER DE MUDAR TAMBM EM: PROJECT OPTIONS - VERSION INFO.

implementation

uses ProcessDlg, ConfigSINTEGRA, ConfigDirGeracao, Math, About,
  AtendimentoCliente, MovimentoPorECF;


{$R *.dfm}

function validaParametros(_Edit: TEdit): Boolean;
begin
  with fmMain do
  begin

    Result := True; //valor default

    if not ECF.bOnLine then Exit;

    if rdoCOO.Checked then
    begin
      if StrToInt(_Edit.Text) > ECF.iCOO then //se o valor do Edit for maior que o COO do ECF
      begin
        MessageDlg('O COO informado deve ser menor ou igual ao COO do ECF.' + #13 +
        'Valor mximo: ' + IntToStr(ECF.iCOO) + '.',
          mtInformation, [mbOk], 0);
        _Edit.SetFocus;

        Result := False;
      end;
    end;

    if rdoCRZ.Checked then
    begin
      if StrToInt(_Edit.Text) > ECF.iCRZ then //se o valor do Edit for maior que o COO do ECF
      begin
        MessageDlg('O CRZ informado deve ser menor ou igual ao CRZ do ECF.' + #13 +
          'Valor mximo: ' + IntToStr(ECF.iCRZ) + '.',
          mtInformation, [mbOk], 0);
        _Edit.SetFocus;

        Result := False
      end;
    end;
    
  end;

end;

procedure TfmMain.habilitarPeriodo(Sender: TObject);
var
  i: Integer;
  sRetornoECF : String;

begin
  //Obtem o tipo de intervalo dos relatrios selecionados.
  //Para mais informaes sobre o tipo de intervalo para cada relatrio
  //consulte o help online da DarumaFramework.dll no link abaixo:
  //http://www.desenvolvedoresdaruma.com.br/home/downloads/Site_2011/Help/DarumaFrameworkHelpOnline/Daruma_Framework.htm
  for i := 0 to (fmMain.gbxRelatorios.ControlCount) - 1 do
  begin
    if not ((fmMain.gbxRelatorios.Controls[i] is TLabel) or (fmMain.gbxRelatorios.Controls[i] is TEdit)) then
    begin
      if (fmMain.gbxRelatorios.Controls[i] as TCheckBox).Checked then
      begin
        case (fmMain.gbxRelatorios.Controls[i] as TCheckBox).Tag of
          0: bData := true;
          1: bCOO  := true;
          2: bCRZ  := true;
        end;
      end;
    end;
  end;

  if chkLMF_S.Checked or chkLMF_C.Checked then
    bCRZ := true;
    
  if bData then
  begin
    bCOO := false;
    bCRZ := false;
  end
  else
    bData := bCOO or bCRZ; //todos relatrios podem ser gerados por data, logo se h algum relatrio selecionado,
                           // o tipo de intervalo 'data' tambm fica disponvel.

  if bCOO and bCRZ then    //se h selecionado relatrios com os tipos de intervalos COO e CRZ, deve-se desabilitar
  begin                    //ambos e deixar apenas por data, pois no se pode gerar por intervalos de COO e CRZ ao mesmo tempo.
    bCOO := false;
    bCRZ := false;
  end;

  fmMain.rdoData.Enabled := bData;
  fmMain.rdoCOO.Enabled  := bCOO;
  fmMain.rdoCRZ.Enabled  := bCRZ;
end;

procedure TfmMain.btInfoECFClick(Sender: TObject);
var
  bMostraECFInfo: Boolean;
begin
  bMostraECFInfo := not pnlInformacoesECF.Visible;
  btInfoECF.Down := bMostraECFInfo;

  pnlInformacoesECF.Visible := bMostraECFInfo;

  if bMostraECFInfo then
    Height := Height + pnlInformacoesECF.Height
  else
    Height := Height - pnlInformacoesECF.Height;

end;

procedure TfmMain.tratamentoPeriodos(Sender: TObject);
begin

  if (chkEMFD.Checked and not chkEMF_C.Checked and not chkEMF_S.Checked and not
  chkMF.Checked and not chkMFD.Checked and not chkNFP.Checked and not
  chkNFP_TDM.checked and not chkSPED.Checked and not chkSintegra.Checked and not
  chkTDM.Checked and not chkVivanota.Checked and not chkMovimentoPorECF.Checked) then

  begin
      dtpDataInicial.MaxDate := dtDataECF;
      dtpDataFinal.MaxDate := dtDataECF;
  end
  else
  begin
      dtpDataInicial.MaxDate := dtDataUltMvto;
      dtpDataFinal.MaxDate := dtDataUltMvto;
  end;

  if(chkSPED.Checked=true) then
  begin
    lbl_PIS_1.Visible:=true;
    lbl_PIS_2.Visible:=true;
    lbl_PIS_3.Visible:=true;
    EDT_PIS.Visible:=true;
    EDT_COFINS.Visible:=true;
  end
  else
  begin
    lbl_PIS_1.Visible:=false;
    lbl_PIS_2.Visible:=false;
    lbl_PIS_3.Visible:=false;
    EDT_PIS.Visible:=false;
    EDT_COFINS.Visible:=false;
  end;

  if Sender is TLabel then Exit;

  bCOO  := false;
  bDATA := false;
  bCRZ  := false;  

  //Quando selecionado um relatrio, verifica os tipos de intervalos permitidos em comum com outros relatrios j selecionados
  //ex 1: Se selecionados todos os relatrios, ser possvel gerar apenas por DATA pois  o tipo de intervalo comum entre todos.
  //ex 2: Seleciono o relatrio Memoria Fiscal que  possvel gerar por DATA e CRZ e tambm seleciono o relatrio Memria Fita Detalhe
  //que  possvel apenas por DATA e COO, terei apenas a opo de gerar por DATA pois  o tipo de intervalo comum entre os dois relatrios.
  //H relatrios que permitem gerar apenas por intervalo de DATA, neste caso desabilita intervalos de CRZ e COO.
  habilitarPeriodo(Sender);

  rdoCOO.Enabled  := bCOO;
  rdoCRZ.Enabled  := bCRZ;
  rdoData.Enabled := bDATA;

  edInicio.Enabled     := bDATA or bCOO or bCRZ;
  edFim.Enabled        := bDATA or bCOO or bCRZ;

  dtpDataInicial.Enabled := bDATA or bCOO or bCRZ;
  dtpDataFinal.Enabled   := bDATA or bCOO or bCRZ;

  if bCOO or bCRZ then
  begin
    edInicio.Visible := True;
    edFim.Visible    := True;
    dtpDataInicial.Visible := False;
    dtpDataFinal.Visible   := False;
  end
  else
  begin
    edInicio.Visible := False;
    edFim.Visible    := False;
    dtpDataInicial.Visible := True;
    dtpDataFinal.Visible   := True;
  end;

  //controle de foco dos radio buttons
  if bCOO  then
  begin
    rdoCOO.SetFocus;
    Exit;
  end;
  if bCRZ  then
  begin
    rdoCRZ.SetFocus;
    Exit;
  end;
  if bDATA then
  begin
    rdoData.SetFocus;
    Exit;
  end;

end;

procedure TfmMain.FormCreate(Sender: TObject);
var
  fStyle: DWORD;
  DirDefault: String;
  GAD_Config: TIniFile;
  sXMLTagValue: String;
begin

    lbl_PIS_1.Visible:=false;
    lbl_PIS_2.Visible:=false;
    lbl_PIS_3.Visible:=false;
    EDT_PIS.Visible:=false;
    EDT_COFINS.Visible:=false;

       sXMLTagValue := StringOfChar(#0, 3);

    regRetornaValorChave_DarumaFramework('ECF', 'VelocidadeGeracaoRelatorio', sXMLTagValue) ;
    if( StrToInt(sXMLTagValue) > 0 )then
      begin
        chkVelocidadeGeracao.Checked := true;
      end
      else
      begin
        chkVelocidadeGeracao.Checked := false;
     end;

  DirDefault := ExtractFilePath(Application.ExeName);
                  
  if FileExists(ExtractFilePath(Application.ExeName) + 'GADConfig.ini') then
  begin
    GAD_Config := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'GADConfig.ini');
    try
      DirDefault := GAD_Config.ReadString('PRINCIPAL', 'DirGeracao', EmptyStr);
      sChaveAssinatura := GAD_Config.ReadString('PRINCIPAL', 'DirChave', EmptyStr);
      chkAssinarArquivos.Checked := GAD_Config.ReadBool('PRINCIPAL', 'AssinarRelatorios', False);
      chkSepararRelatorios.Checked := GAD_Config.ReadBool('PRINCIPAL', 'SepararRelatorios', False);
    finally
      GAD_Config.Free;
    end;
  end
  else
  begin

    GAD_Config := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'GADConfig.ini');
    try
      GAD_Config.WriteString('PRINCIPAL', 'DirGeracao', DirDefault);
      GAD_Config.WriteBool('PRINCIPAL', 'AssinarRelatorios', False);
      GAD_Config.WriteString('PRINCIPAL', 'DirChave', EmptyStr);
      GAD_Config.WriteBool('PRINCIPAL', 'SepararRelatorios', True);

      GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Modelo', True);
      GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'NSerie', True);
      GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Tipo',   True);
      GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Data',   True);
      GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Hora',   True);
    finally
      GAD_Config.Free;
    end;
    chkAssinarArquivos.Checked := False;
  end;

  //defini que os edits especificados aceite apenas nmeros (controle feito pelo sistema operacional)
  fStyle :=  GetWindowLong(edInicio.Handle,GWL_STYLE);
  SetWindowLong(edInicio.Handle, GWL_STYLE, fStyle or ES_NUMBER);
  fStyle :=  GetWindowLong(edFim.Handle,GWL_STYLE);
  SetWindowLong(edFim.Handle, GWL_STYLE, fStyle or ES_NUMBER);

  bAbortProcess := false;

  //altera o XML para que os metodos retornem -12 quando houver algum aviso ou erro
  regAlterarValor_Daruma('ECF\RetornarAvisoErro', '1');

  //inicia a thread que fica monitorando o status do ECF.
  ThreadCarregarDados := TThreadCarregarDados.Create(False);
  ThreadCarregarDados.FreeOnTerminate := True;

  edLocalArquivos.Text := DirDefault;

  Caption := 'GAD - Gerador de Arquivos Daruma [' + PROGRAM_VERSION + ']';

  dtpDataInicial.Date := Date();
  dtpDataFinal.Date   := Date();  
end;

procedure TfmMain.btGerarClick(Sender: TObject);
var
  i, QtdImpressos: Integer;
  isChecked: Boolean;
  ThreadGerarRelatorios: TThreadGerarRelatorios;
  sCaminho: String;
  
  procedure adicionaItemListView(sValue: String);
  var
    lvItem: TListItem;
  begin
    with fmProcessDlg do
    begin
      lvItem := ListView1.Items.Add;
      lvItem.ImageIndex := -1;
      lvItem.SubItems.Add(sValue);
    end;
  end;

  procedure VerifGerarArqInf();
  begin
    if ( not bGerarArqInf) and ( not chkGerarOffline.Checked ) then
      bGerarArqInf := True;
  end;

  procedure VerifDownloadMF();
  begin
    if ( not bDownloadMF ) and ( not chkGerarOffline.Checked )then
    begin
      VerifGerarArqInf();
      bDownloadMF := True;
    end;
  end;

  procedure VerifDownloadMFD();
  begin
    if ( not bDownloadMFD ) and ( not chkGerarOffline.Checked ) then
    begin
      VerifGerarArqInf();
      bDownloadMFD := True;
    end;
  end;
  var
  verificaIndice:Integer;
begin
  //faz a validao dos parmetros
  if(chkGerarOffline.Checked) then chkGerarOfflineClick(chkGerarOffline);

  if not validaParametros(edInicio) then Exit;
  if not validaParametros(edFim) then Exit;

  //verifica se o ECF est online
  if not ECF.bOnLine and ( not chkGerarOffline.Checked )then
  begin
    MessageDlg('No foi possvel comunicar com a impressora fiscal.' +
      ' Verifique se a mesma est conectada ao computador.',
      mtError,  [mbOk], 0);

    ThreadCarregarDados.Resume;
    Exit;
  end;

  isChecked := False;
  bTratamentoNFP_NFPTDM := False;
  QtdImpressos := 0;

  //Antes de adicionar os itens no ListView deve-se limpar o conteudo antigo.
  fmProcessDlg.ListView1.Clear;

  //verifica se existem relatrios a serem impressos e adiciona o ListView da tela de Progresso da gerao.
  for i := 0 to gbxImpressos.ControlCount - 1 do
  begin
    if (gbxImpressos.Controls[i] as TCheckBox).Checked then
    begin
      adicionaItemListView('Imprimindo ' + (gbxImpressos.Controls[i] as TCheckBox).Caption);
      isChecked := True;
      Inc(QtdImpressos);
    end;
  end;

  if not chkGerarOffline.Checked then
  begin
  bDownloadMF  := False;
  bDownloadMFD := False;
  bGerarArqInf := False;

  //Adiciona estes itens primeiro pois antes de qualquer gerao, sero feitos estes processos primeiro
  //com excesso de relatrios impressos e de Espelhos da MF, MFD que so as 3 primeiras opes.
  //Mais abaixo, caso no seja necessrio gerar estes arquivos, o mesmos sero excludos do ListView.
  adicionaItemListView('Gerando arquivo de informaes do ECF.');
  adicionaItemListView('Fazendo o download dos binrios da MF.');
  adicionaItemListView('Fazendo o download dos binrios da MFD.');
  end;

  //Verifica os relatrios que sero gerados, adiciona no ListView da tela de Progresso da gerao, e verifica
  //a necessidade de fazer o download dos binrios MF e MFD.
  for i := 0 to gbxRelatorios.ControlCount - 1 do
  begin
    if not ((gbxRelatorios.Controls[i] is TLabel) or (gbxRelatorios.Controls[i] is TEdit)) then
    begin
      if (gbxRelatorios.Controls[i] as TCheckBox).Checked then
      begin
        isChecked := true;

        //***tratamento de gerao dos arquivos NF* e NF*_TDM***
        //Ambos so gerados com o mesmo nome, portanto, se gerados no mesmo diretrio um sobrescrever o outro.
        //O mtodo rGerarRelatorioOffline_ECF_Daruma se encarrega de renomear os arquivos quando  passado pro mesmo gerar
        //NF* e NF*_TDM simultaneamente. O metodo ir adicionar TDM no final do nome dos arquivos do NF*_TDM.
        //OBS: o nico modo de separar totalmente os arquivos um do outro  marcando a opo 'Separar relatrios em subpastas'
        //e marcar o modo de separao por tipo, onde cada um  gerado na pasta de acordo com o nome do relatrio,
        //logo se no estiver pra separar por tipo, os arquivos sero gerados no mesmo dir.

        verificaIndice:= gbxRelatorios.Controls[i].ComponentIndex;

        //ShowMessage(IntToStr(verificaIndice)); // Verifica o index dos itens adicionados no groupbox Relatorios

        if ((gbxRelatorios.Controls[i] as TCheckBox).ComponentIndex in [48, 47] ) then  //<-- se for NF* ou NF*_TDM
        begin

          if (chkNFP.Checked and chkNFP_TDM.Checked) and  //<-- Verifica se ambos esto marcados
            (not bTratamentoNFP_NFPTDM) and
            ( (not chkSepararRelatorios.Checked) or
            ( chkSepararRelatorios.Checked and not fmConfigDirGeracao.chkTipo.Checked ) ) then //<-- se estiver marcado para separar os arquivos porm no est marcado para seprar-los por tipo
          begin

            //obs: NF*_TDM necessita de ambos arquivos binrios (MF e MFD).
            VerifDownloadMF();
            VerifDownloadMFD();

            adicionaItemListView('Gerando Nota Fiscal Estadual TDM');

            bTratamentoNFP_NFPTDM := True;

          end
          else
          begin

            if (not bTratamentoNFP_NFPTDM) and (chkNFP.Checked and chkNFP_TDM.Checked) then
            begin
              VerifDownloadMF();
              VerifDownloadMFD();
            end;

            if (not bTratamentoNFP_NFPTDM) and ((gbxRelatorios.Controls[i] as TCheckBox).ComponentIndex = 48) then
            begin

              //obs: NF*_TDM necessita de ambos arquivos binrios (MF e MFD).
              VerifDownloadMF();
              VerifDownloadMFD();
              adicionaItemListView('Gerando Nota Fiscal Estadual TDM');

            end
            else
            if (not bTratamentoNFP_NFPTDM) then
            begin

              VerifDownloadMFD();
              adicionaItemListView('Gerando Nota Fiscal Estadual');

            end;
          end;
        end
        else
        begin

          //Verifica a necessidade de fazer o download dos binrios da MF e MFD
          //**ATENO: cuidado ao alterar os componentes do formulario pois mudaro os ndices abaixo.**
          if ( not bDownloadMF ) and ((gbxRelatorios.Controls[i] as TCheckBox).ComponentIndex in [45, 48, 52, 51, 55]) then
            VerifDownloadMF();

          if ( not bDownloadMFD ) and  ((gbxRelatorios.Controls[i] as TCheckBox).ComponentIndex in [52, 46, 47, 48, 49, 50, 51, 55]) then
            VerifDownloadMFD();

          adicionaItemListView('Gerando ' + (gbxRelatorios.Controls[i] as TCheckBox).Caption);

        end;

        //habilita o lbAbrirDiretorioGeracao da tela fmProcessDlg
        fmProcessDlg.lbAbrirDiretorioGeracao.Visible := True;
      end;
    end;
  end;

  if not isChecked then
  begin
    MessageDlg('No h nenhum relatrio selecionado!', mtInformation, [mbOk], 0);  
    Exit;
  end;

  //Remove do ListView o que for desnecessrio.
  //A variavel QtdImpressos (usada abaixo)  a quantidade de relatrios que sero impressos,
  //como os impressos so os primeiros da lista, pra que possa excluir os itens relacionados ao
  //download da MF/MFD e gerao do .inf (quando desnecessrios),  somado com QtdImpressos
  if not bDownloadMF and not bDownloadMFD and ( not chkGerarOffline.Checked ) then
  begin
    // feito em ordem decrescente pois ao excluir algum dos itens no ListView os ndices mudam.
    fmProcessDlg.ListView1.Items[QtdImpressos + 2].Delete;
    fmProcessDlg.ListView1.Items[QtdImpressos + 1].Delete;
    fmProcessDlg.ListView1.Items[QtdImpressos + 0].Delete;
  end
  else
  begin
    if not bDownloadMF and ( not chkGerarOffline.Checked ) then
      fmProcessDlg.ListView1.Items[QtdImpressos + 1].Delete;

    if not bDownloadMFD and ( not chkGerarOffline.Checked ) then
      fmProcessDlg.ListView1.Items[QtdImpressos + 2].Delete;
  end;

  bCOO  := rdoCOO.Checked;
  bCRZ  := rdoCRZ.Checked;
  bDATA := rdoData.Checked;

  //valida os intervalos informados.
  if (bCOO or bCRZ) and (StrToInt(edFim.Text) < StrToInt(edInicio.Text)) then
  begin
    if bCOO then
      MessageDlg('Intervalo de COO invlido! O COO inicial deve ser menor ou igual ao COO final.', mtInformation, [mbOk], 0)
    else
      MessageDlg('Intervalo de CRZ invlido! O CRZ inicial deve ser menor ou igual ao CRZ final.', mtInformation, [mbOk], 0);

    edInicio.SetFocus;
    Exit;
  end;

  if (bDATA) and (dtpDataFinal.Date < dtpDataInicial.Date) then
  begin
    MessageDlg('Intervalo de data invlido! A data inicial deve ser menor ou igual a data final.', mtInformation, [mbOk], 0);
    dtpDataInicial.SetFocus;
    Exit;
  end;

  if Trim(edLocalArquivos.Text) = EmptyStr then
  begin
    MessageDlg('Informe o diretrio onde sero gerados os relatrios.', mtInformation, [mbOk], 0);
    edLocalArquivos.SetFocus;
    Exit;    
  end;

  if ECF.bOnLine or chkGerarOffline.Checked then
  begin
    fmProcessDlg.Show;

    sCaminho := fmMain.edLocalArquivos.Text + fmConfigDirGeracao.sDirGeracao;

    //tratamento do caminho para abrir a pasta onde foram gerados os arquivos.
    if (Pos('<Tipo>', sCaminho) > 0) then
      sCaminho := Copy(sCaminho, 0, Pos('<Tipo>', sCaminho) - 1)
    else if (Pos('<Hora>', sCaminho) > 0) then
      sCaminho := Copy(sCaminho, 0, Pos('<Hora>', sCaminho) - 1);

    fmProcessDlg.sDirArquivos := sCaminho;

    if not DirectoryExists(sCaminho) then
      ForceDirectories(sCaminho);

    regAlterarValor_Daruma('START\LocalArquivosRelatorios', edLocalArquivos.Text);
    regAlterarValor_Daruma('START\LocalArquivos', edLocalArquivos.Text);

    ThreadCarregarDados.Suspend;
    
    //declaro a thread que gera os arquivos.
    ThreadGerarRelatorios := TThreadGerarRelatorios.Create(True);
    ThreadGerarRelatorios.FreeOnTerminate := True;
    ThreadGerarRelatorios.Resume;

  end;

end;

procedure TfmMain.edInicioExit(Sender: TObject);
var
  _Edit: TEdit;
begin
  _Edit := (Sender as TEdit);

  if _Edit.Text = EmptyStr then
    _Edit.Text := '1'
  else
    validaParametros(_Edit);
    
end;

procedure TfmMain.chkSintegra2Click(Sender: TObject);
begin
  if chkSintegra.Checked then
  begin
    if fmConfSintegra.ShowModal = mrCancel then
      chkSintegra.Checked := false
  end;
  tratamentoPeriodos(Sender);
end;

procedure TfmMain.Button2Click(Sender: TObject);
const
  SELDIRHELP = 1000;
var
  sDir: String;
begin
   if SelectDirectory(sDir, [sdAllowCreate, sdPerformCreate,
    sdPrompt], SELDIRHELP) then
  begin
    if not (Length(sDir) = 3) then //tratamento caso diretrio seja C:\, D:\ .. etc..
      sDir := sDir + '\';
    edLocalArquivos.Text := sDir;
  end;
end;

procedure TfmMain.chkSepararRelatoriosClick(Sender: TObject);
begin
  if chkSepararRelatorios.Checked then
  begin
    fmConfigDirGeracao.ShowModal;
    if fmConfigDirGeracao.ModalResult = mrCancel then
      chkSepararRelatorios.Checked := false;
  end;
end;

procedure TfmMain.btAtualizarDadosECFClick(Sender: TObject);
begin
  ECF.bOnLine := False;
  btAtualizarDadosECF.Enabled := False;
  ThreadCarregarDados.bRecarregadDados := True;
end;

procedure TfmMain.rdoCOOClick(Sender: TObject);
begin
  if not rdoData.Checked then
  begin
    edInicio.Visible := True;
    edFim.Visible    := True;
    dtpDataInicial.Visible := False;
    dtpDataFinal.Visible   := False;
  end
  else
  begin
    edInicio.Visible := False;
    edFim.Visible    := False;
    dtpDataInicial.Visible := True;
    dtpDataFinal.Visible   := True;
  end;
end;

procedure TfmMain.Timer1Timer(Sender: TObject);
begin
  lbDataHora_PC.Caption := 'Data/Hora do computador: ' + FormatDateTime('dd/mm/yyyy', Date()) +
    ' [' + FormatDateTime('hh:mm:ss', Time()) + ']';
end;

procedure TfmMain.lbShowLogMouseEnter(Sender: TObject);
begin
  lbShowLog.Font.Color := clHotLight;
end;

procedure TfmMain.lbShowLogMouseLeave(Sender: TObject);
begin
  lbShowLog.Font.Color := clHighlight;
end;

procedure TfmMain.lbShowLogClick(Sender: TObject);
begin
  fmAbout.ShowModal;
end;

procedure TfmMain.chkSintegraClick(Sender: TObject);
begin
  if chkSintegra.Checked then
  begin
    if fmConfSintegra.ShowModal = mrCancel then
      chkSintegra.Checked := False;
  end;

  tratamentoPeriodos(Sender);
end;

procedure TfmMain.FormClose(Sender: TObject; var Action: TCloseAction);
var
  GAD_Config: TIniFile;
begin
  GAD_Config := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'GADConfig.ini');
  try
    GAD_Config.WriteString('PRINCIPAL', 'DirGeracao', edLocalArquivos.Text);
    GAD_Config.WriteString('PRINCIPAL', 'DirChave', sChaveAssinatura);
    GAD_Config.WriteBool('PRINCIPAL', 'AssinarRelatorios', chkAssinarArquivos.Checked);
    GAD_Config.WriteBool('PRINCIPAL', 'SepararRelatorios', chkSepararRelatorios.Checked);
  finally
    GAD_Config.Free;
  end;
end;

procedure TfmMain.chkAssinarArquivosClick(Sender: TObject);
begin
  sChaveAssinatura := EmptyStr;

  if chkAssinarArquivos.Checked then
  begin
    if OpenDialog1.Execute then
      sChaveAssinatura := OpenDialog1.FileName;
  end;

  if sChaveAssinatura = EmptyStr then
    chkAssinarArquivos.Checked := false;
end;
procedure TfmMain.btAtendimentoClilenteClick(Sender: TObject);
begin
 frmAtentimentoCliente.ShowModal;
end;

procedure TfmMain.chkGerarOfflineClick(Sender: TObject);
begin
if(chkGerarOffline.Checked) then
begin
  chkSepararRelatorios.Enabled := False;
  chkSepararRelatorios.Checked := False;
end;

if(not chkGerarOffline.Checked) then
begin
  chkSepararRelatorios.Enabled := true;
end;


if(chkGerarOffline.Checked) then
begin
  chkEMFD.Enabled := False;
  chkEMFD.Checked := False;
end;
if(not chkGerarOffline.Checked) then
begin
  chkEMFD.Enabled := true;
end;

if(chkGerarOffline.Checked) then
begin
  chkEMF_C.Enabled := False;
  chkEMF_C.Checked := False;
end;
if(not chkGerarOffline.Checked) then
begin
  chkEMF_C.Enabled := true;
end;

if(chkGerarOffline.Checked) then
begin
  chkEMF_S.Enabled := False;
  chkEMF_S.Checked := False;
end;
if(not chkGerarOffline.Checked) then
begin
  chkEMF_S.Enabled := true;
end;

if(chkGerarOffline.Checked) then
begin
  chkLX.Enabled := False;
  chkLX.Checked := False;
end;
if(not chkGerarOffline.Checked) then
begin
  chkLX.Enabled := true;
end;

if(chkGerarOffline.Checked) then
begin
  chkLMF_C.Enabled := False;
  chkLMF_C.Checked := False;
end;
if(not chkGerarOffline.Checked) then
begin
  chkLMF_C.Enabled := true;
end;

if(chkGerarOffline.Checked) then
begin
  chkLMF_S.Enabled := False;
  chkLMF_S.Checked := False;
end;
if(not chkGerarOffline.Checked) then
begin
  chkLMF_S.Enabled := true;
end;
if(chkGerarOffline.Checked) then
begin
  if(not FileExists(sLocalArquivosRelatorios + 'Daruma.inf'))then
  begin
    ShowMessage('Para Gerar Relatorio Offline favor incluir binarios necessrios no diretrio de Relatorios.');
    btGerar.Enabled := False;
    chkGerarOffline.Checked := False;
  end
  else
    begin
        btGerar.Enabled := True;
        chkGerarOffline.Checked := True;
    end;
end;

if(chkGerarOffline.Checked) then
begin
  if(chkMF.Checked or chkTDM.Checked or chkNFP_TDM.Checked or chkVivanota.Checked or chkMovimentoPorECF.Checked)then
  begin
      if(not FileExists(sLocalArquivosRelatorios + 'Daruma.mf'))then
      begin
        ShowMessage('Para Gerar Relatorio Offline favor incluir binarios necessrios no diretrio de Relatorios.');
        btGerar.Enabled := False;
        chkGerarOffline.Checked := False;
      end
      else
        begin
          btGerar.Enabled := True;
          chkGerarOffline.Checked := True;;
        end;
  end;
end;

if(chkGerarOffline.Checked) then
begin
  if(chkMFD.Checked or chkTDM.Checked or chkNFP.Checked or chkNFP_TDM.Checked or chkSPED.Checked or chkSintegra.Checked or chkVivanota.Checked or chkMovimentoPorECF.Checked)then
  begin
      if(not FileExists(sLocalArquivosRelatorios + 'Daruma.mfd'))then
      begin
        ShowMessage('Para Gerar Relatorio Offline favor incluir binarios necessrios no diretrio de Relatorios.');
        btGerar.Enabled := False;
        chkGerarOffline.Checked := False;
      end
      else
      begin
          btGerar.Enabled := True;
          chkGerarOffline.Checked := True;
      end;
  end;
end;
if(not chkGerarOffline.Checked) then
begin
  btGerar.Enabled := True;
end;

end;

procedure TfmMain.chkAuditoriaClick(Sender: TObject);
begin
 if(chkAuditoria.Checked = true)then
 begin
  regAlterarValor_Daruma('ECF\Auditoria','1');
 end
 else
 begin
  regAlterarValor_Daruma('ECF\Auditoria','0');
 end;

end;

procedure TfmMain.chkVelocidadeGeracaoClick(Sender: TObject);
begin
if(chkVelocidadeGeracao.Checked = true)then
 begin
  regAlterarValor_Daruma('ECF\VelocidadeGeracaoRelatorio','1');
 end
 else
 begin
  regAlterarValor_Daruma('ECF\VelocidadeGeracaoRelatorio','0');
 end;

end;

procedure TfmMain.chkMovimentoPorECFClick(Sender: TObject);
begin
 if chkMovimentoPorECF.Checked then
  begin
    if fmMovimentoPorECF.ShowModal = mrCancel then
      chkMovimentoPorECF.Checked := False;
  end;
  tratamentoPeriodos(Sender);
end;

end.
