unit LogErros;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, StdCtrls, ComCtrls;

type
  TfmLogErros = class(TForm)
    Panel1: TPanel;
    RichEdit1: TRichEdit;
    btFechar: TButton;
    lbShowLog: TLabel;
    SaveDialog1: TSaveDialog;
    procedure btFecharClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDeactivate(Sender: TObject);
    procedure lbShowLogMouseEnter(Sender: TObject);
    procedure lbShowLogMouseLeave(Sender: TObject);
    procedure lbShowLogClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmLogErros: TfmLogErros;

implementation

uses Main;

{$R *.dfm}

procedure TfmLogErros.btFecharClick(Sender: TObject);
begin
  fmLogErros.RichEdit1.Lines.Clear;
  Close;
end;

procedure TfmLogErros.FormShow(Sender: TObject);
begin
  btFechar.SetFocus;
  ModalResult := mrNone;
end;

procedure TfmLogErros.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ModalResult := mrOk;
end;

procedure TfmLogErros.FormDeactivate(Sender: TObject);
begin
  //Este trecho faz com que a janela no perca o foco enquanto nao for
  //encerrada pelo boto fechar ou boto Ok/Abrotar.
  if ModalResult <> mrOk then Show;
end;

procedure TfmLogErros.lbShowLogMouseEnter(Sender: TObject);
begin
  lbShowLog.Font.Color := clHotLight
end;

procedure TfmLogErros.lbShowLogMouseLeave(Sender: TObject);
begin
  lbShowLog.Font.Color := clHighlight;
end;

procedure TfmLogErros.lbShowLogClick(Sender: TObject);
var
  slTexto: TStringList;
begin
  if SaveDialog1.Execute then
  begin
    slTexto := TStringList.Create;

    //cabealho do arquivo
    slTexto.Add('Log de erro - GAD - verso: ' + PROGRAM_VERSION);
    slTexto.Add('Data: ' + FormatDateTime('dd/mm/yyyy - hh:mm', Now()));
    slTexto.Add('ECF: ' + fmMain.ECF.sModeloECF + ' - N.Srie: ' + fmMain.ECF.sNumSerie + #13#10 + #13#10);


    if SaveDialog1.FileName <> EmptyStr then
    begin
      //Passa do RichText para o StringList para remover a formatao de RichText (.rtf);
      slTexto.Add(RichEdit1.Lines.Text);

      if ExtractFileExt(SaveDialog1.FileName) = EmptyStr then
        SaveDialog1.FileName := SaveDialog1.FileName + '.txt';

      slTexto.SaveToFile(SaveDialog1.FileName);
      slTexto.Free;
    end;
  end;
end;

end.
