unit ConfigSINTEGRA;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, xmldom, XMLIntf, msxmldom, XMLDoc;

type
  TfmConfSintegra = class(TForm)
    gbxParamSintegra: TGroupBox;
    Label4: TLabel;
    edEndereco: TEdit;
    Label1: TLabel;
    edBairro: TEdit;
    Label3: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    edNumero: TEdit;
    Label6: TLabel;
    edCEP: TEdit;
    edNomeContato: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    cboFinalidade: TComboBox;
    cboIdentifConvenio: TComboBox;
    cboNatuOperacao: TComboBox;
    Label11: TLabel;
    edComplemento: TEdit;
    edMunicipio: TEdit;
    Label12: TLabel;
    cboUF: TComboBox;
    edFinalidade: TEdit;
    edIdentifConvenio: TEdit;
    edNatuOperacao: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label13: TLabel;
    edTelefone: TMaskEdit;
    edFax: TMaskEdit;
    procedure Button1Click(Sender: TObject);
    procedure cboFinalidadeChange(Sender: TObject);
    procedure cboIdentifConvenioChange(Sender: TObject);
    procedure cboNatuOperacaoChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end; 
var
  fmConfSintegra: TfmConfSintegra;

implementation

uses Main;

{$R *.dfm}

procedure TfmConfSintegra.Button1Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfmConfSintegra.cboFinalidadeChange(Sender: TObject);
begin

  case cboFinalidade.ItemIndex of
    0:edFinalidade.Text:= 'Normal';
    1:edFinalidade.Text:= 'Retificao total de arquivo';
    2:edFinalidade.Text:= 'Retificao adit iva de arquivo';
    3:edFinalidade.Text:= 'Retificao corretiva.';
    4:edFinalidade.Text:= 'Desfazimento: arquivo de informao referente a operaes/prestaes no efetivadas.';
  end;
  
end;

procedure TfmConfSintegra.cboIdentifConvenioChange(Sender: TObject);
begin

  case cboIdentifConvenio.ItemIndex of
    0: edIdentifConvenio.Text:= 'Convnio ICMS 31/99';
    1: edIdentifConvenio.Text:= 'Convnio ICMS 69/02 e 142/02';
    2: edIdentifConvenio.Text:= 'Convnio ICMS 76/03 e 20/04';
  end;

end;

procedure TfmConfSintegra.cboNatuOperacaoChange(Sender: TObject);
begin

  case cboNatuOperacao.ItemIndex of
    0: edNatuOperacao.Text:= 'Interestaduais somente com substituio tributria.';
    1: edNatuOperacao.Text:= 'Interestaduais com ou sem substituio tributria.';
    2: edNatuOperacao.Text:= 'Totalidade das operaes do informante.';
  end;
  
end;

procedure TfmConfSintegra.Button2Click(Sender: TObject);
var
  i: Integer;
begin

  for i := 0 to gbxParamSintegra.ControlCount -1 do
  begin
    if gbxParamSintegra.Controls[i] is TEdit then
    begin
      if Trim((gbxParamSintegra.Controls[i] as TEdit).Text) = EmptyStr then
      begin
        MessageDlg('Todos os campos devem estar preenchidos!', mtInformation, [mbOk], 0);
        (gbxParamSintegra.Controls[i] as TEdit).SetFocus;
        Exit;
      end;
    end;
  end;

  regSintegra_ECF_Daruma('Logradouro', edEndereco.Text);
  regSintegra_ECF_Daruma('Numero', edNumero.Text);
  regSintegra_ECF_Daruma('Complemento', edComplemento.Text);
  regSintegra_ECF_Daruma('Bairro', edBairro.Text);
  regSintegra_ECF_Daruma('Municipio', edMunicipio.Text);
  regSintegra_ECF_Daruma('UF', cboUF.Text);
  regSintegra_ECF_Daruma('CEP', edCEP.Text);
  regSintegra_ECF_Daruma('Contato_Telefone', edTelefone.Text);
  regSintegra_ECF_Daruma('Fax', edFax.Text);
  regSintegra_ECF_Daruma('Contato_Nome', edNomeContato.Text);
  regSintegra_ECF_Daruma('Cod_Finalidade', IntToStr(cboFinalidade.ItemIndex + 1)  );
  regSintegra_ECF_Daruma('Cod_Convenio', IntToStr(cboIdentifConvenio.ItemIndex + 1) );
  regSintegra_ECF_Daruma('Cod_Natureza', IntToStr(cboNatuOperacao.ItemIndex + 1)  );

  ModalResult := mrOk;
end;

procedure TfmConfSintegra.FormCreate(Sender: TObject);
var
  fStyle: DWORD;
  sXMLTagValue: String;
begin
  cboUF.ItemIndex := 24;
  cboFinalidade.ItemIndex := 0;
  cboIdentifConvenio.ItemIndex := 2;
  cboNatuOperacao.ItemIndex := 2;
  cboFinalidadeChange(Sender);
  cboIdentifConvenioChange(Sender);
  cboNatuOperacaoChange(Sender);

  //defini que o edit especificado aceite apenas nmeros (controle feito pelo sistema operacional)
  fStyle :=  GetWindowLong(edNumero.Handle,GWL_STYLE);
  SetWindowLong(edNumero.Handle, GWL_STYLE, fStyle or ES_NUMBER);

  //CARREGA DO XML AS INFORMAES DO SINTEGRA

  if FileExists('DarumaFrameWork.xml') then
  begin
    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Logradouro', sXMLTagValue) = RET_OK then
      edEndereco.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Numero', sXMLTagValue) = RET_OK then
      edNumero.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Complemento', sXMLTagValue) = RET_OK then
      edComplemento.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Bairro', sXMLTagValue) = RET_OK then
      edBairro.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'CEP', sXMLTagValue) = RET_OK then
      edCEP.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Municipio', sXMLTagValue) = RET_OK then
      edMunicipio.Text := sXMLTagValue;

     sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'UF', sXMLTagValue) = RET_OK then
      cboUF.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Contato_Telefone', sXMLTagValue) = RET_OK then
      edTelefone.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Fax', sXMLTagValue) = RET_OK then
      edFax.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Contato_Nome', sXMLTagValue) = RET_OK then
      edNomeContato.Text := sXMLTagValue;

    sXMLTagValue := StringOfChar(#0, 200);
    try
      if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Cod_Convenio', sXMLTagValue) = RET_OK then
        cboIdentifConvenio.ItemIndex := StrToInt(sXMLTagValue) - 1;

      sXMLTagValue := StringOfChar(#0, 200);
      if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Cod_Finalidade', sXMLTagValue) = RET_OK then
        cboFinalidade.ItemIndex := StrToInt(sXMLTagValue) - 1;

        sXMLTagValue := StringOfChar(#0, 200);
       if regRetornaValorChave_DarumaFramework('ECF\SINTEGRA', 'Cod_Natureza', sXMLTagValue) = RET_OK then
        cboNatuOperacao.ItemIndex := StrToInt(sXMLTagValue) - 1;
    except

    sXMLTagValue := StringOfChar(#0, 200);
    end;

  end;
end;

procedure TfmConfSintegra.FormShow(Sender: TObject);
begin
  edEndereco.SetFocus();
end;

end.
