unit ConfigDirGeracao;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, IniFiles;

type
  TfmConfigDirGeracao = class(TForm)
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Bevel1: TBevel;
    Panel1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    chkModelo: TCheckBox;
    chkNumSerie: TCheckBox;
    chkTipo: TCheckBox;
    chkData: TCheckBox;
    chkHora: TCheckBox;
    lbCaminho: TLabel;
    procedure chkModeloClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure montarDiretorio();
  private
    { Private declarations }
  public
    { Public declarations }
    sDirGeracao: String;
  end;

var
  fmConfigDirGeracao: TfmConfigDirGeracao;

implementation

uses Main;

{$R *.dfm}

procedure TfmConfigDirGeracao.montarDiretorio;
begin                
  with fmConfigDirGeracao do
  begin
    sDirGeracao := EmptyStr;

    if chkModelo.Checked   then sDirGeracao := sDirGeracao + fmMain.ECF.sModeloECF + '\';
    if chkNumSerie.Checked then sDirGeracao := sDirGeracao + fmMain.ECF.sNumSerie + '\';

    //as seguintes tags <Tipo> e <Hora> sero substitudas por: Nome do relatrio e hora em que iniciou a gerao dos arquivos.
    if chkTipo.Checked then sDirGeracao := sDirGeracao + '<Tipo>\';
    if chkData.Checked then sDirGeracao := sDirGeracao + FormatDateTime('ddmmyy\', Date());
    if chkHora.Checked then sDirGeracao := sDirGeracao + '<Hora>\';  //formato hhmm

    //verifica se o tamanho do diretrio principal no  muito grande para mostrar o caminho completo na tela
    //caso seja grande ser resumido com reticncias (...)
    if Length(fmMain.edLocalArquivos.Text) < 20 then
      lbCaminho.Caption := fmMain.edLocalArquivos.Text + sDirGeracao
    else
    begin
      lbCaminho.Caption := Copy(fmMain.edLocalArquivos.Text, 0, pos('\', fmMain.edLocalArquivos.Text)) +
        '...\' + sDirGeracao;
    end;
  end;
end;

procedure TfmConfigDirGeracao.chkModeloClick(Sender: TObject);
begin
  montarDiretorio();
end;

procedure TfmConfigDirGeracao.FormShow(Sender: TObject);
begin
  montarDiretorio();
end;

procedure TfmConfigDirGeracao.Button1Click(Sender: TObject);
var
  GAD_Config: TIniFile;
begin
  //Salva as configuraes da diviso dos relatrios
  GAD_Config := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'GADConfig.ini');

  GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Modelo', chkModelo.Checked);
  GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'NSerie', chkNumSerie.Checked);
  GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Tipo',   chkTipo.Checked);
  GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Data',   chkData.Checked);
  GAD_Config.WriteBool('DIVISAO-ARQUIVOS', 'Hora',   chkHora.Checked);

  GAD_Config.Free;
end;

procedure TfmConfigDirGeracao.FormCreate(Sender: TObject);
var
  GAD_Config: TIniFile;
begin
  GAD_Config := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'GADConfig.ini');
  try
    chkModelo.Checked   := GAD_Config.ReadBool('DIVISAO-ARQUIVOS', 'Modelo', False);
    chkNumSerie.Checked := GAD_Config.ReadBool('DIVISAO-ARQUIVOS', 'NSerie', False);
    chkTipo.Checked     := GAD_Config.ReadBool('DIVISAO-ARQUIVOS', 'Tipo',   False);
    chkData.Checked     := GAD_Config.ReadBool('DIVISAO-ARQUIVOS', 'Data',   False);
    chkHora.Checked     := GAD_Config.ReadBool('DIVISAO-ARQUIVOS', 'Hora',   False);
  finally
    GAD_Config.Free;
  end;

  montarDiretorio();
end;

end.
