* Program:		WIZARD.PRG
* Description:	Main program of Wizard.app
* Written by:	John Alden (Alden Anderson, Inc.)
* Version:		.071

* Parameters:
*	wbcpClass	- class designation for wizards, eg "FORM", "REPORT"
*	wbcpName	- name of specific wizard to run, correlates to "classname" or "program" fields in reg table
* 	wbcpOptions	- optional parameters - e.g. "NOSCRN", "MODIFY"
* 	wbcpP1-9	- optional parameters to pass to wizard

* Comments:
*	Naming conventions used in wizard.prg, builder.prg, and wb.prg -
*		- all variables begin with "wb"
*		- the third character designates variable type
*		- parameters have "p" as their fourth character, e.g. "wbcpOptions"
* -----------------------------------------------------------------------------------------------------------------

PARAMETERS wbcpClass, wbcpName, wbcpOptions, wbcpP1, wbcpP2, wbcpP3, wbcpP4, wbcpP5, wbcpP6, wbcpP7, wbcpP8, wbcpP9

LOCAL liOldLanguageOptions
liOldLanguageOptions = _vfp.LanguageOptions
_vfp.LanguageOptions = 0	&& turn off strict memvar checking (jd 11/26/00)

m.wbOptionalParms = parameters() - 3	&& first 3 are known parameters, remainder are optional

#DEFINE C_WIZARD_LOC			"WIZARD"

* This section added to support calls to report wizard from screens generated by 2.6 form wizard - click on "Print",
* calls wizard.app with incorrect parameters. Adjust parameters so that it becomes a call to the report wizard with
* "autoformat".

IF TYPE("m.wbcpName") = "C" AND m.wbcpName = "WZ_QREPO"
	m.wbcpName = "WZREPORT"
	m.wbcpOptions = m.wbcpOptions + " NOTASK AUTOREPORT "
ENDIF

m.wbStartingProc = SET("PROCEDURE")

IF NOT 'WBMAIN' $ SET("PROCEDURE")
	SET PROCEDURE TO WBMAIN ADDITIVE				&& main wizard/builder class library
ENDIF

m.wbcWizVer = " version .071"
m.wblError = .f.
m.wbReturnValue = ""

m.wboObject = CREATEOBJ("wizard")			&& create wizard object - class definition below

wboObject.wbOptParms = m.wbOptionalParms

wboObject.wblModal = .t.
IF TYPE("wbcpOptions") = "C"
	LOCAL cDate
	m.cDate = SET('DATE')
	SET DATE TO MDY
	IF " SNOQUALMIE::FLEW " $ " " + UPPER(m.wbcpOptions) + " "
		wboObject.wblModal = .f.
	ENDIF
	SET DATE TO &cDate
ENDIF

wboObject.WBSaveEnvironment				&& save environment
wboObject.WBSetProps					&& set properties of the wizard object
wboObject.WBCheckparms					&& verify parameters
wboObject.WBCheckErrors					&& check for certain errors
IF m.wblError
	_vfp.LanguageOptions = liOldLanguageOptions 	&& restore memvar checking value (jd 11/26/00)
	RETURN
ENDIF
wboObject.WBSetTools					&& load the tools library
wboObject.WBSetPlatform					&& platform-specific code

wboObject.WBGetRegTable					&& locate registration table
IF NOT EMPTY(wboObject.wbcRegTable)
	wboObject.WBGetName					&& get name of wizard
	IF NOT EMPTY(wboObject.wbcName)	
		wboObject.WBCall				&& call specific wizard
	ENDIF
ENDIF

IF wboObject.wblModal
	wboObject.WBSetEnvironment				&& restore environment if modal (else it's an automated test)
ENDIF
m.wbReturnValue = wboObject.wbReturnValue
RELEASE wboObject

IF NOT EMPTY(m.wbStartingProc)
	SET PROCEDURE TO &wbStartingProc
ELSE
	SET PROCEDURE TO
ENDIF

_vfp.LanguageOptions = liOldLanguageOptions 	&& restore memvar checking value (jd 11/26/00)

RETURN m.wbReturnValue



DEFINE CLASS Wizard AS WizBldr		
* --------------------------------------------------------------------------------------
* The WizBldr parent class is defined in the WB.PRG class library. The wizard class is 
* set up as a subclass as an opportunity for customizing wizards. Code overriding methods 
* from the parent, for example, could go here.
* --------------------------------------------------------------------------------------

	m.wbcType = "WIZARD"				&& do not localize
	m.wbcTypeDisplay = C_WIZARD_LOC		&& this line is localizable, defined at top of this file
	
ENDDEFINE

